/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.dispatcher;

import org.openvpms.archetype.component.dispatcher.Dispatcher;
import org.openvpms.archetype.component.dispatcher.Queues;
import org.openvpms.archetype.rules.laboratory.LaboratoryRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.laboratory.internal.dispatcher.Confirmation;
import org.openvpms.laboratory.internal.dispatcher.OrderDispatcher;
import org.openvpms.laboratory.internal.dispatcher.OrderQueue;
import org.openvpms.laboratory.internal.dispatcher.OrderQueues;
import org.openvpms.laboratory.internal.dispatcher.OrderService;
import org.openvpms.laboratory.order.Order;
import org.openvpms.laboratory.order.OrderConfirmation;
import org.openvpms.laboratory.service.LaboratoryService;
import org.openvpms.laboratory.service.LaboratoryServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderDispatcherImpl
extends Dispatcher<Act, Entity, OrderQueue>
implements OrderDispatcher {
    private final LaboratoryServices laboratoryServices;
    private final ArchetypeService service;
    private final DomainService domainService;
    private final OrderService orderService;
    private static final Logger log = LoggerFactory.getLogger(OrderDispatcherImpl.class);

    public OrderDispatcherImpl(LaboratoryServices laboratoryServices, IArchetypeService service, DomainService domainService, PracticeService practiceService, LaboratoryRules rules) {
        this(laboratoryServices, service, domainService, practiceService, new OrderService((ArchetypeService)service, rules));
    }

    protected OrderDispatcherImpl(LaboratoryServices laboratoryServices, IArchetypeService service, DomainService domainService, PracticeService practiceService, OrderService orderService) {
        this(laboratoryServices, service, domainService, practiceService, orderService, (Queues<Entity, OrderQueue>)new OrderQueues(orderService, service));
    }

    protected OrderDispatcherImpl(LaboratoryServices laboratoryServices, IArchetypeService service, DomainService domainService, PracticeService practiceService, OrderService orderService, Queues<Entity, OrderQueue> orderQueues) {
        super(practiceService, log);
        this.laboratoryServices = laboratoryServices;
        this.service = service;
        this.domainService = domainService;
        this.orderService = orderService;
        this.init(orderQueues);
    }

    @Override
    public void create(Act investigation) {
        IMObjectBean bean = this.service.getBean((IMObject)investigation);
        boolean confirmOrder = bean.getBoolean("confirmOrder");
        Act order = (Act)bean.getTarget("order", Act.class);
        if (order == null) {
            if (confirmOrder) {
                this.orderService.createOrder(investigation, false);
            } else {
                this.orderService.createOrder(investigation, true);
                this.schedule();
            }
        }
    }

    @Override
    public Confirmation order(Act investigation) {
        Order order;
        IMObjectBean bean = this.service.getBean((IMObject)investigation);
        Act orderAct = (Act)bean.getTarget("order", Act.class);
        Entity laboratory = (Entity)bean.getTarget("laboratory", Entity.class);
        if (laboratory == null) {
            throw new IllegalStateException("Investigation has no laboratory");
        }
        if (orderAct == null) {
            orderAct = this.orderService.createOrder(investigation, false);
        }
        if (!Order.Type.NEW.equals((Object)(order = (Order)this.domainService.create((IMObject)orderAct, Order.class)).getType())) {
            throw new IllegalStateException("Expected NEW order but got " + order.getType());
        }
        LaboratoryService laboratoryService = this.laboratoryServices.getService(laboratory);
        if (Order.Status.PENDING.equals((Object)order.getStatus())) {
            laboratoryService.order(order);
        }
        OrderConfirmation confirmation = null;
        if (Order.Status.CONFIRM.equals((Object)order.getStatus())) {
            confirmation = laboratoryService.getOrderConfirmation(order);
        }
        return confirmation != null ? new Confirmation(order, confirmation, laboratoryService) : null;
    }

    @Override
    public void cancel(Act investigation) {
        IMObjectBean bean = this.service.getBean((IMObject)investigation);
        Act order = (Act)bean.getTarget("order", Act.class);
        if (order != null) {
            Entity laboratory = (Entity)this.service.getBean((IMObject)order).getTarget("laboratory", Entity.class);
            if (laboratory != null) {
                OrderQueue queue = (OrderQueue)this.getQueue(laboratory);
                if (queue != null && queue.cancel(order)) {
                    this.schedule();
                }
            } else {
                log.error("No laboratory for for order=" + order.getId());
            }
        } else {
            log.error("No order for investigation=" + investigation.getId());
        }
    }

    protected void process(Act object, OrderQueue queue) {
        Entity laboratory = (Entity)queue.getOwner();
        LaboratoryService laboratoryService = this.laboratoryServices.getService(laboratory);
        Order order = (Order)this.domainService.create((IMObject)object, Order.class);
        IMObjectBean bean = this.service.getBean((IMObject)object);
        if (Order.Type.NEW.name().equals(bean.getString("type"))) {
            laboratoryService.order(order);
        } else {
            laboratoryService.cancel(order);
        }
        queue.processed();
    }

    protected String toString(Act object) {
        return object.getObjectReference().toString();
    }
}

