/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.service;

public class OrderValidationStatus {
    private final Status status;
    private final String message;

    private OrderValidationStatus(Status status) {
        this(status, null);
    }

    private OrderValidationStatus(Status status, String message) {
        this.status = status;
        this.message = message;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public static OrderValidationStatus valid() {
        return new OrderValidationStatus(Status.VALID);
    }

    public static OrderValidationStatus warning(String message) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 'message' must be provided");
        }
        return new OrderValidationStatus(Status.WARNING, message);
    }

    public static OrderValidationStatus error(String message) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 'message' must be provided");
        }
        return new OrderValidationStatus(Status.ERROR, message);
    }

    public static enum Status {
        VALID,
        WARNING,
        ERROR;

    }
}

