/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.internal.i18n;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.component.i18n.Message;
import org.openvpms.insurance.internal.i18n.InsuranceMessages;

public class InsuranceMessagesTestCase {
    @Test
    public void testCannotFinaliseClaimWithStatus() {
        this.check("INS-0001: Cannot finalise claims with 'foo' status", InsuranceMessages.cannotFinaliseClaimWithStatus((String)"foo"));
    }

    @Test
    public void testCannotFinaliseClaimAttachmentError() {
        this.check("INS-0002: This claim cannot be finalised.\n\nThe 'foo' attachment is not valid", InsuranceMessages.cannotFinaliseClaimAttachmentError((String)"foo"));
    }

    @Test
    public void testCannotFinaliseClaimNoAttachment() {
        this.check("INS-0003: This claim cannot be finalised.\n\nThe 'foo' attachment has no content", InsuranceMessages.cannotFinaliseClaimNoAttachment((String)"foo"));
    }

    @Test
    public void testFailedToFinaliseClaim() {
        this.check("INS-0004: The claim could not be finalised: foo", InsuranceMessages.failedToFinaliseClaim((String)"foo"));
    }

    @Test
    public void testDifferentClaimIdentifierArchetype() {
        this.check("INS-0005: Cannot change claim identifier archetypes from foo to bar", InsuranceMessages.differentClaimIdentifierArchetype((String)"foo", (String)"bar"));
    }

    @Test
    public void testAttachmentHasNoContent() {
        this.check("INS-0020: Attachment 'foo' has no content", InsuranceMessages.attachmentHasNoContent((String)"foo"));
    }

    @Test
    public void testPolicyHasNoId() {
        this.check("INS-0030: Policy has no Policy Number", InsuranceMessages.policyHasNoId());
    }

    @Test
    public void testPolicyHasNoInsurer() {
        this.check("INS-0031: Policy has no insurer", InsuranceMessages.policyHasNoInsurer());
    }

    @Test
    public void testPolicyHasNoPatient() {
        this.check("INS-0032: Policy has no patient", InsuranceMessages.policyHasNoPatient());
    }

    @Test
    public void testpolicyHasNoCustomer() {
        this.check("INS-0033: Policy has no customer", InsuranceMessages.policyHasNoCustomer());
    }

    @Test
    public void testServiceUnavailable() {
        this.check("INS-0040: foo is currently not available", InsuranceMessages.serviceUnavailable((String)"foo"));
    }

    @Test
    public void testInactive() {
        this.check("INS-0041: foo has been deactivated.\n\nThis is required by bar to submit claims and validate policies.", InsuranceMessages.serviceInactive((String)"foo", (String)"bar"));
    }

    @Test
    public void testBenefitPaymentNotes() {
        Assert.assertEquals((Object)"Benefit Payment for Insurance Claim 1 for foo submitted to bar", (Object)InsuranceMessages.benefitPaymentNotes((String)"1", (String)"foo", (String)"bar").getMessage());
    }

    private void check(String expected, Message actual) {
        Assert.assertEquals((Object)expected, (Object)actual.toString());
    }
}

