/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.internal.claim;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.credit.CreditActAllocator;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentBuilder;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.insurance.claim.Claim;
import org.openvpms.insurance.claim.Deposit;
import org.openvpms.insurance.claim.GapClaim;
import org.openvpms.insurance.internal.claim.AbstractClaimTest;
import org.openvpms.insurance.internal.claim.GapClaimImpl;
import org.springframework.beans.factory.annotation.Autowired;

public class GapClaimImplTestCase
extends AbstractClaimTest {
    private Entity till;
    @Autowired
    private TestCustomerAccountFactory accountFactory;

    @Override
    public void setUp() {
        super.setUp();
        this.till = this.practiceFactory.createTill();
        this.practiceFactory.updateLocation(this.location).tills(new Entity[]{this.till}).build();
    }

    @Test
    public void testPayGap() {
        this.checkPayClaim(true, BigDecimal.valueOf(80L));
    }

    @Test
    public void testPayFullClaim() {
        this.checkPayClaim(false, BigDecimal.valueOf(80L));
    }

    @Test
    public void testZeroBenefit() {
        this.checkPayClaim(true, BigDecimal.ZERO);
        this.checkPayClaim(false, BigDecimal.ZERO);
    }

    @Test
    public void testSetVetBenefitAmount() {
        FinancialAct claimAct = this.createClaim();
        GapClaimImpl claim = this.createGapClaim(claimAct);
        BigDecimal amount = BigDecimal.valueOf(50L);
        claim.setVetBenefitAmount(amount);
        claim = this.createGapClaim((FinancialAct)this.get((IMObject)claimAct));
        this.checkEquals(amount, claim.getVetBenefitAmount());
    }

    @Test
    public void testSettle() {
        FinancialAct claimAct = this.createClaim();
        GapClaimImpl claim = this.createGapClaim(claimAct);
        BigDecimal amount = BigDecimal.valueOf(80L);
        claim.setBenefit(amount, "accepted");
        FinancialAct payment = claim.gapPaid(this.till, this.location);
        this.checkBenefitPayment(payment, amount, "GAP_BENEFIT_PAYMENT", (Claim)claim);
        BigDecimal vetBenefit = BigDecimal.valueOf(70L);
        OffsetDateTime date1 = DateRules.toOffsetDateTime((Date)DateRules.getYesterday());
        OffsetDateTime date2 = DateRules.toOffsetDateTime((Date)DateRules.getToday());
        claim.state().vetBenefitAmount(vetBenefit).deposit("1", "actIdentity.insuranceDepositTest", date1, BigDecimal.valueOf(40L)).deposit("2", "actIdentity.insuranceDepositTest", date2, BigDecimal.valueOf(30L)).status(Claim.Status.SETTLED).update();
        claim = this.createGapClaim((FinancialAct)this.get((IMObject)claimAct));
        Assert.assertEquals((Object)Claim.Status.SETTLED, (Object)claim.getStatus());
        this.checkEquals(vetBenefit, claim.getVetBenefitAmount());
        List deposits = claim.getDeposits();
        Assert.assertEquals((long)2L, (long)deposits.size());
        this.checkDeposit(deposits, "1", date1, BigDecimal.valueOf(40L));
        this.checkDeposit(deposits, "2", date2, BigDecimal.valueOf(30L));
    }

    @Test
    public void testDuplicateDeposit() {
        FinancialAct claimAct = this.createClaim();
        GapClaimImpl claim = this.createGapClaim(claimAct);
        BigDecimal amount = BigDecimal.valueOf(80L);
        claim.setBenefit(amount, "accepted");
        FinancialAct payment = claim.gapPaid(this.till, this.location);
        this.checkBenefitPayment(payment, amount, "GAP_BENEFIT_PAYMENT", (Claim)claim);
        BigDecimal vetBenefit = BigDecimal.valueOf(70L);
        OffsetDateTime date1 = DateRules.toOffsetDateTime((Date)DateRules.getYesterday());
        OffsetDateTime date2 = DateRules.toOffsetDateTime((Date)DateRules.getToday());
        try {
            claim.state().vetBenefitAmount(vetBenefit).deposit("1", "actIdentity.insuranceDepositTest", date1, BigDecimal.valueOf(40L)).deposit("1", "actIdentity.insuranceDepositTest", date2, BigDecimal.valueOf(30L)).status(Claim.Status.SETTLED).update();
        }
        catch (IllegalArgumentException exception) {
            Assert.assertEquals((Object)"Duplicate deposit with identifier 1", (Object)exception.getMessage());
        }
        claim.state().vetBenefitAmount(vetBenefit).deposit("1", "actIdentity.insuranceDepositTest", date1, BigDecimal.valueOf(40L)).status(Claim.Status.SETTLED).update();
        try {
            claim.state().deposit("1", "actIdentity.insuranceDepositTest", date2, BigDecimal.valueOf(30L)).update();
        }
        catch (IllegalArgumentException exception) {
            Assert.assertEquals((Object)"Duplicate deposit with identifier 1", (Object)exception.getMessage());
        }
        claim = this.createGapClaim((FinancialAct)this.get((IMObject)claimAct));
        Assert.assertEquals((Object)Claim.Status.SETTLED, (Object)claim.getStatus());
        this.checkEquals(vetBenefit, claim.getVetBenefitAmount());
        List deposits = claim.getDeposits();
        Assert.assertEquals((long)1L, (long)deposits.size());
        this.checkDeposit(deposits, "1", date1, BigDecimal.valueOf(40L));
    }

    @Test
    public void testInsurerPaymentType() {
        String paymentType = "SPECIAL_PAYMENT_TYPE";
        this.insuranceFactory.updateInsurer(this.insurer1).paymentType(paymentType).build();
        FinancialAct claimAct = this.createClaim();
        GapClaimImpl claim = this.createGapClaim(claimAct);
        BigDecimal amount = BigDecimal.valueOf(80L);
        claim.setBenefit(amount, "accepted");
        FinancialAct payment = claim.gapPaid(this.till, this.location);
        this.checkBenefitPayment(payment, amount, paymentType, (Claim)claim);
    }

    protected void checkPayClaim(boolean payGap, BigDecimal benefit) {
        BigDecimal total = BigDecimal.valueOf(95L);
        BigDecimal gap = total.subtract(benefit);
        Product product1 = this.productFactory.createMedication();
        BigDecimal tax = new BigDecimal("8.64");
        BigDecimal discount = BigDecimal.valueOf(5L);
        FinancialAct invoiceItem1 = this.createInvoiceItem(new Date(), product1, BigDecimal.ONE, MathRules.ONE_HUNDRED, discount, tax);
        FinancialAct invoice1 = this.createInvoice(new Date(), invoiceItem1);
        FinancialAct invoiceItem2 = this.createInvoiceItem(new Date(), product1, BigDecimal.ONE, MathRules.ONE_HUNDRED, discount, tax);
        FinancialAct invoice2 = this.createInvoice(new Date(), invoiceItem2);
        FinancialAct claimAct = (FinancialAct)this.insuranceFactory.newClaim().policy(this.policyAct).location(this.location).clinician(this.clinician).claimHandler(this.user).gapClaim(true).item().diagnosis("VENOM_328", "Abscess", "328").invoiceItems(new FinancialAct[]{invoiceItem2}).add().build();
        GapClaimImpl claim = this.createGapClaim(claimAct);
        Assert.assertEquals((Object)Claim.Status.PENDING, (Object)claim.getStatus());
        Assert.assertEquals((Object)GapClaim.GapStatus.PENDING, (Object)claim.getGapStatus());
        this.checkEquals(total, claim.getTotal());
        this.checkEquals(BigDecimal.ZERO, claim.getBenefitAmount());
        this.checkEquals(total, claim.getGapAmount());
        this.checkEquals(discount, claim.getDiscount());
        this.checkEquals(tax, claim.getTotalTax());
        Assert.assertNull((Object)claim.getBenefitNotes());
        this.checkEquals(BigDecimal.ZERO, claim.getCurrentPaid());
        this.checkEquals(total, claim.getCurrentBalance());
        claim.setStatus(Claim.Status.ACCEPTED);
        claim.setBenefit(benefit, "Accepted");
        Assert.assertEquals((Object)GapClaim.GapStatus.RECEIVED, (Object)claim.getGapStatus());
        Assert.assertEquals((Object)"Accepted", (Object)claim.getBenefitNotes());
        this.checkEquals(benefit, claim.getBenefitAmount());
        this.checkEquals(gap, claim.getGapAmount());
        this.checkEquals(total, claim.getTotal());
        FinancialAct adjustment = null;
        BigDecimal pay = payGap ? gap : total;
        List<FinancialAct> paymentActs = this.createPayment(pay);
        FinancialAct payment = paymentActs.get(0);
        CreditActAllocator allocator = new CreditActAllocator(this.getArchetypeService(), this.insuranceRules);
        List updated = allocator.allocate(payment, invoice2);
        Assert.assertEquals((long)2L, (long)updated.size());
        updated.add(paymentActs.get(1));
        this.save(updated);
        this.checkAllocation(payment, pay);
        this.checkAllocation(invoice2, pay);
        this.checkAllocation(invoice1, BigDecimal.ZERO);
        if (payGap) {
            Entity till = this.practiceFactory.createTill();
            adjustment = claim.gapPaid(till, this.location);
        } else {
            claim.fullyPaid();
        }
        this.checkEquals(claim.getTotal(), claim.getCurrentPaid());
        this.checkEquals(BigDecimal.ZERO, claim.getCurrentBalance());
        Assert.assertEquals((Object)GapClaim.GapStatus.PAID, (Object)claim.getGapStatus());
        if (payGap) {
            this.checkEquals(gap, claim.getPaid());
            if (!MathRules.isZero((BigDecimal)benefit)) {
                this.checkBenefitPayment(adjustment, benefit, "GAP_BENEFIT_PAYMENT", (Claim)claim);
            } else {
                Assert.assertNull((Object)adjustment);
            }
        } else {
            this.checkEquals(total, claim.getPaid());
        }
        this.checkAllocation(payment, pay);
        this.checkAllocation(invoice2, total);
        this.checkAllocation(invoice1, BigDecimal.ZERO);
    }

    private FinancialAct createClaim() {
        BigDecimal tax = new BigDecimal("8.64");
        BigDecimal discount = BigDecimal.valueOf(5L);
        FinancialAct invoiceItem1 = this.createInvoiceItem(new Date(), this.productFactory.createService(), BigDecimal.ONE, MathRules.ONE_HUNDRED, discount, tax);
        this.createInvoice(new Date(), invoiceItem1);
        return (FinancialAct)this.newClaim().gapClaim(true).item().diagnosis("VENOM_328", "Abcess", "328").invoiceItems(new FinancialAct[]{invoiceItem1}).add().build();
    }

    private void checkDeposit(List<Deposit> deposits, String id, OffsetDateTime date, BigDecimal amount) {
        boolean found = false;
        for (Deposit deposit : deposits) {
            if (!deposit.getDepositId().equals(id)) continue;
            Assert.assertEquals((Object)date, (Object)deposit.getDate());
            this.checkEquals(amount, deposit.getAmount());
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found);
    }

    private List<FinancialAct> createPayment(BigDecimal amount) {
        TestPaymentBuilder builder = this.accountFactory.newPayment();
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)builder.customer(this.customer)).status("POSTED")).cash(amount).till(this.till)).build(false);
        ArrayList<FinancialAct> result = new ArrayList<FinancialAct>();
        result.add(payment);
        result.addAll(builder.getItems());
        return result;
    }

    private void checkAllocation(FinancialAct act, BigDecimal expected) {
        this.checkEquals(expected, ((FinancialAct)this.get((IMObject)act)).getAllocatedAmount());
    }

    private void checkBenefitPayment(FinancialAct payment, BigDecimal amount, String paymentType, Claim claim) {
        Assert.assertNotNull((Object)payment);
        Assert.assertTrue((boolean)payment.isA("act.customerAccountPayment"));
        Assert.assertEquals((Object)"POSTED", (Object)payment.getStatus());
        this.checkEquals(amount, payment.getTotal());
        IMObjectBean bean = this.getBean((IMObject)payment);
        Assert.assertEquals((Object)("Benefit Payment for Insurance Claim " + claim.getInsurerId() + " for " + this.patient.getName() + " submitted to " + this.insurer1.getName()), (Object)bean.getString("notes"));
        FinancialAct item = (FinancialAct)bean.getTarget("items", FinancialAct.class);
        Assert.assertNotNull((Object)item);
        Assert.assertTrue((boolean)item.isA("act.customerAccountPaymentOther"));
        IMObjectBean itemBean = this.getBean((IMObject)item);
        Assert.assertEquals((Object)paymentType, (Object)itemBean.getString("paymentType"));
        this.checkAllocation(payment, amount);
    }
}

