/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.internal.claim;

import java.math.BigDecimal;
import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemBuilder;
import org.openvpms.archetype.test.builder.insurance.TestClaimBuilder;
import org.openvpms.archetype.test.builder.insurance.TestInsuranceFactory;
import org.openvpms.archetype.test.builder.party.TestEmailContactBuilder;
import org.openvpms.archetype.test.builder.party.TestPhoneContactBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestLocationBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.insurance.internal.claim.ClaimImpl;
import org.openvpms.insurance.internal.claim.GapClaimImpl;
import org.openvpms.insurance.policy.Policy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public abstract class AbstractClaimTest
extends ArchetypeServiceTest {
    protected Party practice;
    protected Party customer;
    protected Party patient;
    protected Date dateOfBirth;
    protected User clinician;
    protected Party location;
    protected Contact locationPhone;
    protected Contact locationEmail;
    protected User user;
    protected Act policyAct;
    protected Party insurer1;
    protected InsuranceRules insuranceRules;
    @Autowired
    protected TestCustomerFactory customerFactory;
    @Autowired
    protected TestInsuranceFactory insuranceFactory;
    @Autowired
    protected TestPatientFactory patientFactory;
    @Autowired
    protected TestPracticeFactory practiceFactory;
    @Autowired
    protected TestProductFactory productFactory;
    @Autowired
    protected TestUserFactory userFactory;
    @Autowired
    private CustomerRules customerRules;
    @Autowired
    private CustomerAccountRules customerAccountRules;
    @Autowired
    private PatientRules patientRules;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private DomainService service;
    private DocumentHandlers handlers;

    @Before
    public void setUp() {
        this.practice = (Party)this.practiceFactory.newPractice().addTaxType(BigDecimal.TEN).build();
        this.customer = (Party)((TestCustomerBuilder)((TestCustomerBuilder)((TestCustomerBuilder)this.customerFactory.newCustomer().title("MS").firstName("J").lastName("Bloggs").addAddress("12 Broadwater Avenue", "CAPE_WOOLAMAI", "VIC", "3925", new String[0])).addHomePhone("9123456").addWorkPhone("98765432").addMobilePhone("04987654321")).addEmail("foo@test.com", new String[0])).build();
        IArchetypeService service = this.getArchetypeService();
        this.handlers = new DocumentHandlers((ArchetypeService)service);
        this.insuranceRules = new InsuranceRules((IArchetypeService)((IArchetypeRuleService)service), this.transactionManager);
        this.locationPhone = new TestPhoneContactBuilder((ArchetypeService)service).phone("5123456").build();
        this.locationEmail = new TestEmailContactBuilder((ArchetypeService)service).email("vetsrus@test.com").build();
        this.location = (Party)((TestLocationBuilder)((TestLocationBuilder)this.practiceFactory.newLocation().addContact(this.locationEmail)).addContact(this.locationPhone)).build();
        this.clinician = this.userFactory.createClinician();
        this.user = this.userFactory.createUser("Z", "Smith");
        this.dateOfBirth = DateRules.getDate((Date)DateRules.getToday(), (int)-1, (DateUnits)DateUnits.YEARS);
        this.patient = (Party)((TestPatientBuilder)this.patientFactory.newPatient().name("Fido")).species("CANINE").breed("PUG").sex("MALE").dateOfBirth(this.dateOfBirth).addMicrochip("123454321").colour("BLACK").owner(this.customer).build();
        this.insurer1 = this.insuranceFactory.createInsurer();
        this.policyAct = this.insuranceFactory.createPolicy(this.customer, this.patient, this.insurer1, "POL123456");
    }

    protected void checkPolicy(Policy policy, Party insurer, String policyNumber) {
        Assert.assertEquals((Object)insurer, (Object)policy.getInsurer());
        Assert.assertEquals((Object)policyNumber, (Object)policy.getPolicyNumber());
    }

    protected ClaimImpl getClaim(Act act) {
        return new ClaimImpl(act, (IArchetypeService)((IArchetypeRuleService)this.getArchetypeService()), this.insuranceRules, this.customerRules, this.patientRules, this.handlers, this.transactionManager, this.service);
    }

    protected GapClaimImpl createGapClaim(FinancialAct act) {
        return new GapClaimImpl(act, (IArchetypeService)((IArchetypeRuleService)this.getArchetypeService()), this.insuranceRules, this.customerRules, this.customerAccountRules, this.patientRules, this.handlers, this.transactionManager, this.service);
    }

    protected FinancialAct createInvoiceItem(int amount) {
        return this.createInvoiceItem(BigDecimal.valueOf(amount));
    }

    protected FinancialAct createInvoiceItem(BigDecimal amount) {
        return (FinancialAct)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)new TestInvoiceItemBuilder(null, (ArchetypeService)this.getArchetypeService()).patient(this.patient)).product(this.productFactory.createService())).quantity(BigDecimal.ONE)).unitPrice(amount)).clinician(this.clinician)).build(false);
    }

    protected FinancialAct createInvoiceItem(Date date, Product product, BigDecimal quantity, BigDecimal price, BigDecimal discount, BigDecimal tax) {
        return (FinancialAct)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)new TestInvoiceItemBuilder(null, (ArchetypeService)this.getArchetypeService()).startTime(date)).patient(this.patient)).product(product)).quantity(quantity)).unitPrice(price)).discount(discount)).tax(tax)).clinician(this.clinician)).build(false);
    }

    protected FinancialAct createInvoice(FinancialAct ... items) {
        return this.createInvoice(new Date(), items);
    }

    protected FinancialAct createInvoice(Date date, FinancialAct ... items) {
        return (FinancialAct)((TestInvoiceBuilder)((TestInvoiceBuilder)((TestInvoiceBuilder)((TestInvoiceBuilder)new TestInvoiceBuilder((ArchetypeService)this.getArchetypeService()).startTime(date)).customer(this.customer)).status("POSTED")).add(items)).build();
    }

    protected TestClaimBuilder newClaim() {
        return this.insuranceFactory.newClaim().policy(this.policyAct).location(this.location).clinician(this.clinician).claimHandler(this.user);
    }
}

