/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.internal.claim;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.service.archetype.functor.ActComparator;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.insurance.claim.Note;

public class NoteImpl
implements Note {
    private final IMObjectBean note;
    private final Act act;
    private final ArchetypeService service;
    private List<Note> addenda;

    public NoteImpl(Act note, ArchetypeService service) {
        this.note = service.getBean((IMObject)note);
        this.act = note;
        this.service = service;
        if (note.isA("act.patientClinicalAddendum")) {
            this.addenda = Collections.emptyList();
        }
    }

    public OffsetDateTime getDate() {
        return DateRules.toOffsetDateTime((Date)this.act.getActivityStartTime());
    }

    public User getAuthor() {
        return (User)this.note.getObject("createdBy", User.class);
    }

    public User getClinician() {
        return (User)this.note.getTarget("clinician", User.class);
    }

    public String getText() {
        return this.note.getString("note");
    }

    public List<Note> getNotes() {
        if (this.addenda == null) {
            this.addenda = this.collectAddenda();
        }
        return this.addenda;
    }

    protected List<Note> collectAddenda() {
        ArrayList<Note> result = new ArrayList<Note>();
        List acts = this.note.getTargets("addenda", Act.class);
        acts.sort(ActComparator.ascending());
        for (Act act : acts) {
            result.add(new NoteImpl(act, this.service));
        }
        return result;
    }
}

