/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.internal.claim;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Date;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.insurance.claim.Item;

public class ItemImpl
implements Item {
    private final IMObjectBean item;
    private final Act act;
    private final ArchetypeService service;

    public ItemImpl(Act item, ArchetypeService service) {
        this.item = service.getBean((IMObject)item);
        this.act = item;
        this.service = service;
    }

    public long getId() {
        return this.act.getId();
    }

    public OffsetDateTime getDate() {
        return DateRules.toOffsetDateTime((Date)this.act.getActivityStartTime());
    }

    public Product getProduct() {
        return (Product)this.item.getTarget("product", Product.class);
    }

    public Entity getProductType() {
        IMObjectBean bean = this.service.getBean((IMObject)this.getProduct());
        return (Entity)bean.getTarget("type", Entity.class, Policies.active());
    }

    public BigDecimal getQuantity() {
        return this.item.getBigDecimal("quantity", BigDecimal.ZERO);
    }

    public BigDecimal getDiscount() {
        return this.item.getBigDecimal("discount", BigDecimal.ZERO);
    }

    public BigDecimal getDiscountTax() {
        BigDecimal total = this.getTotal();
        BigDecimal tax = this.getTotalTax();
        BigDecimal discount = this.getDiscount();
        return !MathRules.isZero((BigDecimal)total) ? MathRules.divide((BigDecimal)tax.multiply(discount), (BigDecimal)total, (int)2) : BigDecimal.ZERO;
    }

    public BigDecimal getTotal() {
        return this.item.getBigDecimal("total", BigDecimal.ZERO);
    }

    public BigDecimal getTotalTax() {
        return this.item.getBigDecimal("tax", BigDecimal.ZERO);
    }
}

