/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.internal.claim;

import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.insurance.claim.Claim;
import org.openvpms.insurance.claim.Claims;
import org.openvpms.insurance.internal.InsuranceFactory;
import org.openvpms.plugin.internal.service.archetype.ArchetypeServiceProxyHelper;

public class ClaimsImpl
implements Claims {
    private final IArchetypeRuleService service;
    private final InsuranceFactory factory;
    private final IArchetypeRuleService proxy;

    public ClaimsImpl(IArchetypeRuleService service, InsuranceFactory factory, PracticeService practiceService) {
        this.service = service;
        this.factory = factory;
        this.proxy = ArchetypeServiceProxyHelper.proxy((IArchetypeRuleService)service, (PracticeService)practiceService);
    }

    public Claim getClaim(String archetype, String id) {
        if (archetype == null || archetype.contains("*") || !TypeHelper.matches((String)archetype, (String)"actIdentity.insuranceClaim*")) {
            throw new IllegalArgumentException("Argument 'archetype' is not a valid claim identity archetype: " + archetype);
        }
        ArchetypeQuery query = new ArchetypeQuery("act.patientInsuranceClaim");
        query.add((IConstraint)Constraints.join((String)"insurerId", (BaseArchetypeConstraint)Constraints.shortName((String)archetype)).add((IConstraint)Constraints.eq((String)"identity", (Object)id)));
        query.add((IConstraint)Constraints.sort((String)"id"));
        query.setMaxResults(1);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator((IArchetypeService)this.service, (IArchetypeQuery)query);
        return iterator.hasNext() ? this.factory.createClaim((Act)iterator.next(), this.proxy) : null;
    }
}

