/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.internal.claim;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.component.business.domain.im.act.ActIdentity;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.insurance.claim.Claim;
import org.openvpms.insurance.claim.ClaimUpdater;
import org.openvpms.insurance.claim.GapClaim;
import org.openvpms.insurance.exception.InsuranceException;
import org.openvpms.insurance.internal.claim.ClaimImpl;
import org.openvpms.insurance.internal.i18n.InsuranceMessages;
import org.openvpms.insurance.internal.policy.PolicyImpl;

class ClaimUpdaterImpl
implements ClaimUpdater {
    private final ClaimImpl claim;
    private final IMObjectBean bean;
    private final ArchetypeService service;
    private final InsuranceRules rules;
    private String archetype;
    private String id;
    private Party insurer;
    private String policyNumber;
    private Claim.Status status;
    private String message;
    private boolean hasMessage;

    public ClaimUpdaterImpl(ClaimImpl claim, IMObjectBean bean, ArchetypeService service, InsuranceRules rules) {
        this.claim = claim;
        this.bean = bean;
        this.service = service;
        this.rules = rules;
    }

    public ClaimUpdater insurerId(String archetype, String id) {
        if (!TypeHelper.isA((String)archetype, (String[])new String[]{"actIdentity.insuranceClaim*"})) {
            throw new IllegalArgumentException("Argument 'archetype' must have a actIdentity.insuranceClaim* prefix");
        }
        if (id == null) {
            throw new IllegalArgumentException("Argument 'id' is required");
        }
        this.archetype = archetype;
        this.id = id;
        return this;
    }

    public ClaimUpdater policy(Party insurer, String policyNumber) {
        if (insurer == null) {
            throw new IllegalArgumentException("Argument 'insurer' is null");
        }
        if (policyNumber == null) {
            throw new IllegalArgumentException("Argument 'policyNumber' is null");
        }
        this.insurer = insurer;
        this.policyNumber = policyNumber;
        return this;
    }

    public ClaimUpdater status(Claim.Status status) {
        this.status = status;
        return this;
    }

    public ClaimUpdater status(Claim.Status status, String message) {
        return this.status(status).message(message);
    }

    public ClaimUpdater message(String message) {
        this.message = message;
        this.hasMessage = true;
        return this;
    }

    public Claim update() {
        ArrayList<IMObject> toSave = new ArrayList<IMObject>();
        boolean updated = this.doUpdate(this.bean, toSave);
        if (updated) {
            this.bean.save(toSave);
        }
        return this.claim;
    }

    protected ClaimImpl getClaim() {
        return this.claim;
    }

    protected IMObjectBean getBean() {
        return this.bean;
    }

    protected ArchetypeService getService() {
        return this.service;
    }

    protected boolean doUpdate(IMObjectBean bean, List<IMObject> toSave) {
        boolean updated = this.updateId();
        updated |= this.updatePolicy(toSave);
        updated |= this.updateStatus();
        return updated |= this.updateMessage();
    }

    private boolean updateId() {
        boolean updated = false;
        if (this.archetype != null && this.id != null) {
            ActIdentity identity = this.claim.getIdentity();
            if (identity == null) {
                identity = (ActIdentity)this.service.create(this.archetype, ActIdentity.class);
                this.bean.addValue("insurerId", (IMObject)identity);
                updated = true;
            } else if (!identity.isA(this.archetype)) {
                throw new InsuranceException(InsuranceMessages.differentClaimIdentifierArchetype(identity.getArchetype(), this.archetype));
            }
            if (!Objects.equals(this.id, identity.getIdentity())) {
                identity.setIdentity(this.id);
                updated = true;
            }
        }
        return updated;
    }

    private boolean updatePolicy(List<IMObject> toSave) {
        PolicyImpl policy;
        boolean updated = false;
        if (!(this.insurer == null || this.policyNumber == null || (policy = this.claim.getPolicyImpl()).getInsurer().equals(this.insurer) && Objects.equals(policy.getPolicyNumber(), this.policyNumber))) {
            Act act = this.rules.getPolicyForClaim(this.claim.getCustomer(), this.claim.getPatient(), this.insurer, this.policyNumber, (FinancialAct)((org.openvpms.component.business.domain.im.act.FinancialAct)this.bean.getObject()), policy.getAct());
            Relationship relationship = this.bean.setTarget("policy", (IMObject)act);
            act.addActRelationship((ActRelationship)((org.openvpms.component.business.domain.im.act.ActRelationship)relationship));
            this.claim.updatePolicy(act);
            toSave.add((IMObject)act);
            updated = true;
        }
        return updated;
    }

    private boolean updateStatus() {
        boolean updated = false;
        if (this.status != null) {
            Claim.Status current = this.claim.getStatus();
            if (current == Claim.Status.CANCELLED || current == Claim.Status.SETTLED || current == Claim.Status.DECLINED) {
                throw new IllegalStateException("Cannot update claim status when it is " + current);
            }
            if (this.status == Claim.Status.PRE_SETTLED && !(this.claim instanceof GapClaim)) {
                throw new IllegalStateException("PRE_SETTLED is not a valid status for standard claims");
            }
            this.bean.setValue("status", (Object)this.status.name());
            if (this.status == Claim.Status.CANCELLED || this.status == Claim.Status.SETTLED || this.status == Claim.Status.DECLINED) {
                this.bean.setValue("endTime", (Object)new Date());
            } else {
                this.bean.setValue("endTime", null);
            }
            updated = true;
        }
        return updated;
    }

    private boolean updateMessage() {
        boolean updated = false;
        if (this.hasMessage) {
            if (!StringUtils.isEmpty((CharSequence)this.message)) {
                this.message = StringUtils.abbreviate((String)this.message, (int)this.bean.getMaxLength("message"));
            }
            if (!Objects.equals(this.message, this.bean.getString("message"))) {
                this.bean.setValue("message", (Object)this.message);
                updated = true;
            }
        }
        return updated;
    }
}

