/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.internal.claim;

import java.io.InputStream;
import java.time.OffsetDateTime;
import java.util.Date;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.insurance.claim.Attachment;
import org.openvpms.insurance.exception.InsuranceException;
import org.openvpms.insurance.internal.i18n.InsuranceMessages;

public class AttachmentImpl
implements Attachment {
    private final IMObjectBean act;
    private final ArchetypeService service;
    private final DocumentHandlers handlers;

    public AttachmentImpl(DocumentAct act, ArchetypeService service, DocumentHandlers handlers) {
        this.act = service.getBean((IMObject)act);
        this.service = service;
        this.handlers = handlers;
    }

    public long getId() {
        return this.getAct().getId();
    }

    public String getInsurerId() {
        ActIdentity identity = this.getIdentity();
        return identity != null ? identity.getIdentity() : null;
    }

    public void setInsurerId(String archetype, String id) {
        ActIdentity identity = this.getIdentity();
        if (identity == null) {
            if (id != null) {
                identity = (ActIdentity)this.service.create(archetype, ActIdentity.class);
                this.act.addValue("insurerId", (IMObject)identity);
            }
        } else if (!identity.isA(archetype)) {
            throw new IllegalArgumentException("Argument 'archetype' must be of the same type as the existing identifier");
        }
        if (id != null) {
            identity.setIdentity(id);
        } else {
            this.getAct().removeIdentity(identity);
        }
        this.act.save();
    }

    public OffsetDateTime getDate() {
        return DateRules.toOffsetDateTime((Date)this.getAct().getActivityStartTime());
    }

    public String getFileName() {
        return this.getAct().getFileName();
    }

    public String getMimeType() {
        return this.getAct().getMimeType();
    }

    public long getSize() {
        long result = 0L;
        Reference document = this.getAct().getDocument();
        if (document != null) {
            CriteriaBuilder builder = this.service.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(Integer.class);
            Root from = query.from(Document.class, new String[]{document.getArchetype()});
            query.select((Selection)from.get("size"));
            query.where((Expression)builder.equal((Expression)from.reference(), (Object)document));
            Integer size = (Integer)this.service.createQuery(query).getFirstResult();
            if (size != null) {
                result = size.intValue();
            }
        }
        return result;
    }

    public boolean hasContent() {
        Reference reference = this.getAct().getDocument();
        return reference != null;
    }

    public InputStream getContent() {
        Document document;
        InputStream result = null;
        DocumentAct documentAct = this.getAct();
        Reference reference = documentAct.getDocument();
        if (reference != null && (document = (Document)this.service.get(reference, Document.class)) != null) {
            result = this.handlers.get(document).getContent(document);
        }
        if (result == null) {
            throw new InsuranceException(InsuranceMessages.attachmentHasNoContent(documentAct.getFileName()));
        }
        return result;
    }

    public Attachment.Status getStatus() {
        return Attachment.Status.valueOf((String)this.getAct().getStatus());
    }

    public void setStatus(Attachment.Status status) {
        this.getAct().setStatus(status.name());
        this.act.save();
    }

    public Attachment.Type getType() {
        Attachment.Type result = Attachment.Type.DOCUMENT;
        String type = this.act.getString("type");
        if ("act.patientClinicalEvent".equals(type)) {
            result = Attachment.Type.CLINICAL_HISTORY;
        } else if ("act.customerAccountChargesInvoice".equals(type)) {
            result = Attachment.Type.INVOICE;
        }
        return result;
    }

    protected DocumentAct getAct() {
        return (DocumentAct)this.act.getObject(DocumentAct.class);
    }

    protected ActIdentity getIdentity() {
        return (ActIdentity)this.act.getObject("insurerId", ActIdentity.class);
    }
}

