/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.internal.claim;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.cache.IMObjectCache;
import org.openvpms.insurance.claim.Condition;
import org.openvpms.insurance.internal.claim.ClaimImpl;
import org.openvpms.insurance.internal.claim.ConditionImpl;
import org.openvpms.insurance.internal.claim.InvoiceImpl;

class Allocations {
    private final ClaimImpl claim;
    private final ArchetypeService service;
    private Map<ConditionImpl, BigDecimal> allocationMap;
    private BigDecimal invoiceAllocation = BigDecimal.ZERO;

    public Allocations(ClaimImpl claim, ArchetypeService service) {
        this.claim = claim;
        this.service = service;
    }

    public BigDecimal getAllocation(ConditionImpl condition) {
        this.lazyInit();
        BigDecimal result = this.allocationMap.get(condition);
        return result != null ? result : BigDecimal.ZERO;
    }

    public BigDecimal getConditionTotal() {
        BigDecimal result = BigDecimal.ZERO;
        this.lazyInit();
        for (Map.Entry<ConditionImpl, BigDecimal> entry : this.allocationMap.entrySet()) {
            result = result.add(entry.getValue());
        }
        return result;
    }

    public BigDecimal getInvoiceTotal() {
        this.lazyInit();
        return this.invoiceAllocation;
    }

    public void clear() {
        this.allocationMap = null;
    }

    private void lazyInit() {
        if (this.allocationMap == null) {
            this.init();
        }
    }

    private void init() {
        this.allocationMap = new HashMap<ConditionImpl, BigDecimal>();
        this.invoiceAllocation = BigDecimal.ZERO;
        List<ConditionImpl> conditions = this.getConditions();
        IMObjectCache cache = this.claim.getCache();
        HashMap<Reference, FinancialAct> allInvoices = new HashMap<Reference, FinancialAct>();
        LinkedHashMap<ConditionImpl, List<InvoiceImpl>> conditionMap = new LinkedHashMap<ConditionImpl, List<InvoiceImpl>>();
        for (ConditionImpl condition : conditions) {
            List<InvoiceImpl> invoices = condition.getInvoiceImpls();
            conditionMap.put(condition, invoices);
            for (InvoiceImpl invoice : invoices) {
                allInvoices.computeIfAbsent(invoice.getObjectReference(), k -> (FinancialAct)cache.get(k));
            }
        }
        for (FinancialAct invoice : allInvoices.values()) {
            BigDecimal allocation = invoice.getAllocatedAmount();
            if (MathRules.isZero((BigDecimal)allocation)) continue;
            BigDecimal allocated = this.allocateInvoiceToConditions(invoice, conditionMap);
            this.invoiceAllocation = this.invoiceAllocation.add(allocated);
        }
    }

    private BigDecimal allocateInvoiceToConditions(FinancialAct invoice, Map<ConditionImpl, List<InvoiceImpl>> conditionMap) {
        BigDecimal maxAllocation;
        BigDecimal amount = maxAllocation = this.getMaximumAllocation(invoice);
        for (Map.Entry<ConditionImpl, List<InvoiceImpl>> entry : conditionMap.entrySet()) {
            if (amount.compareTo(BigDecimal.ZERO) <= 0) break;
            ConditionImpl condition = entry.getKey();
            List<InvoiceImpl> invoices = entry.getValue();
            amount = this.allocateInvoiceToCondition(invoice, condition, amount, invoices);
        }
        if (MathRules.isNegative((BigDecimal)invoice.getTotal())) {
            maxAllocation = maxAllocation.negate();
        }
        return maxAllocation;
    }

    private BigDecimal allocateInvoiceToCondition(FinancialAct invoice, ConditionImpl condition, BigDecimal amount, List<InvoiceImpl> invoices) {
        BigDecimal conditionAllocation = this.allocationMap.get(condition);
        if (conditionAllocation == null) {
            conditionAllocation = BigDecimal.ZERO;
        }
        for (InvoiceImpl match : invoices) {
            if (match.getId() != invoice.getId()) continue;
            BigDecimal total = match.getTotal();
            if (amount.compareTo(total) >= 0) {
                amount = amount.subtract(total);
            } else {
                total = amount;
                amount = BigDecimal.ZERO;
            }
            conditionAllocation = conditionAllocation.add(total);
        }
        this.allocationMap.put(condition, conditionAllocation);
        return amount;
    }

    private List<ConditionImpl> getConditions() {
        ArrayList<ConditionImpl> result = new ArrayList<ConditionImpl>();
        for (Condition condition : this.claim.getConditions()) {
            result.add((ConditionImpl)condition);
        }
        result.sort(Comparator.comparingLong(ConditionImpl::getId));
        return result;
    }

    private BigDecimal getMaximumAllocation(FinancialAct invoice) {
        BigDecimal excludeFromAllocation = BigDecimal.ZERO;
        long id = this.claim.getId();
        IMObjectCache cache = this.claim.getCache();
        IMObjectBean bean = this.service.getBean((IMObject)invoice);
        for (Reference itemRef : bean.getTargetRefs("items")) {
            FinancialAct item = (FinancialAct)cache.get(itemRef, FinancialAct.class);
            if (item == null) {
                throw new IllegalStateException("Invoice item=" + itemRef + " referenced by invoice=" + invoice.getObjectReference() + " not found");
            }
            IMObjectBean itemBean = this.service.getBean((IMObject)item);
            for (Reference reference : itemBean.getSourceRefs("claims")) {
                IMObjectBean claimItemBean;
                Reference claimRef;
                Act claimItem = (Act)cache.get(reference, Act.class);
                if (claimItem == null || (claimRef = (claimItemBean = this.service.getBean((IMObject)claimItem)).getSourceRef("claim")) == null || claimRef.getId() == id || !this.isPaid(claimRef, cache)) continue;
                excludeFromAllocation = excludeFromAllocation.add(item.getTotal());
            }
        }
        BigDecimal result = invoice.getAllocatedAmount().subtract(excludeFromAllocation.abs());
        return MathRules.isNegative((BigDecimal)result) ? BigDecimal.ZERO : result;
    }

    private boolean isPaid(Reference claimRef, IMObjectCache cache) {
        boolean result = false;
        Act claim = (Act)cache.get(claimRef, Act.class);
        if (claim != null) {
            boolean bl = result = "PAID".equals(claim.getStatus2()) || "NOTIFIED".equals(claim.getStatus2());
            if (!result && ("POSTED".equals(claim.getStatus()) || "SUBMITTED".equals(claim.getStatus()) || "ACCEPTED".equals(claim.getStatus()) || "SETTLED".equals(claim.getStatus()))) {
                IMObjectBean bean = this.service.getBean((IMObject)claim);
                result = !bean.getBoolean("gapClaim");
            }
        }
        return result;
    }
}

