/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.internal;

import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.rules.party.PartyRules;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.practice.LocationImpl;
import org.openvpms.domain.practice.Location;
import org.openvpms.insurance.claim.Claim;
import org.openvpms.insurance.internal.claim.ClaimImpl;
import org.openvpms.insurance.internal.claim.GapClaimImpl;
import org.openvpms.insurance.internal.policy.PolicyImpl;
import org.openvpms.insurance.policy.Policy;
import org.springframework.transaction.PlatformTransactionManager;

public class InsuranceFactory {
    private final IArchetypeRuleService service;
    private final InsuranceRules insuranceRules;
    private final CustomerRules customerRules;
    private final CustomerAccountRules accountRules;
    private final PatientRules patientRules;
    private final MedicalRecordRules recordRules;
    private final DocumentHandlers handlers;
    private final PlatformTransactionManager transactionManager;
    private final DomainService domainService;

    public InsuranceFactory(IArchetypeRuleService service, InsuranceRules insuranceRules, CustomerRules customerRules, CustomerAccountRules accountRules, PatientRules patientRules, MedicalRecordRules recordRules, DocumentHandlers handlers, PlatformTransactionManager transactionManager, DomainService domainService) {
        this.service = service;
        this.insuranceRules = insuranceRules;
        this.customerRules = customerRules;
        this.accountRules = accountRules;
        this.patientRules = patientRules;
        this.recordRules = recordRules;
        this.handlers = handlers;
        this.transactionManager = transactionManager;
        this.domainService = domainService;
    }

    public Policy createPolicy(Act policy) {
        return new PolicyImpl(policy, (ArchetypeService)this.service, this.customerRules, this.patientRules, this.domainService);
    }

    public Claim createClaim(Act claim) {
        return this.createClaim(claim, this.service);
    }

    public Claim createClaim(Act claim, IArchetypeRuleService service) {
        IMObjectBean bean = service.getBean((IMObject)claim);
        if (!bean.getBoolean("gapClaim")) {
            return new ClaimImpl(bean, (IArchetypeService)service, this.insuranceRules, this.customerRules, this.patientRules, this.recordRules, this.handlers, this.transactionManager, this.domainService);
        }
        return new GapClaimImpl(bean, (IArchetypeService)service, this.insuranceRules, this.customerRules, this.accountRules, this.patientRules, this.recordRules, this.handlers, this.transactionManager, this.domainService);
    }

    public Location getLocation(Party location) {
        return new LocationImpl(location, (PartyRules)this.customerRules, this.domainService);
    }
}

