/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.internal.claim;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.IterableUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.insurance.InsuranceTestHelper;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentBuilder;
import org.openvpms.archetype.test.builder.patient.TestAddendumBuilder;
import org.openvpms.archetype.test.builder.patient.TestNoteBuilder;
import org.openvpms.archetype.test.builder.patient.TestVisitBuilder;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.functor.ActComparator;
import org.openvpms.component.business.service.security.AuthenticationContextImpl;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.AuditableIMObject;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.domain.patient.Patient;
import org.openvpms.insurance.claim.Claim;
import org.openvpms.insurance.claim.ClaimHandler;
import org.openvpms.insurance.claim.Condition;
import org.openvpms.insurance.claim.Invoice;
import org.openvpms.insurance.claim.Item;
import org.openvpms.insurance.claim.Note;
import org.openvpms.insurance.internal.claim.AbstractClaimTest;
import org.openvpms.insurance.internal.claim.ClaimImpl;
import org.openvpms.insurance.policy.Policy;
import org.springframework.beans.factory.annotation.Autowired;

public class ClaimImplTestCase
extends AbstractClaimTest {
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestProductFactory productFactory;

    @Test
    public void testClaim() {
        User author = this.userFactory.createUser();
        AuthenticationContextImpl context = new AuthenticationContextImpl();
        context.setUser(author);
        String treatFrom1 = "2017-09-27";
        String treatTo1 = "2017-09-29";
        DocumentAct note1 = this.createNote("2015-05-01", this.patient, this.clinician, "Note 1");
        DocumentAct note2 = this.createNote("2015-05-02", this.patient, this.clinician, "Note 2");
        this.createVisit("2015-05-01", "2015-05-02", this.patient, new Act[]{note1, note2});
        DocumentAct note3 = this.createNote("2015-07-01", this.patient, this.clinician, "Note 3");
        DocumentAct addendum1 = this.createAddendum("2015-07-03", this.patient, this.clinician, "Note 3 addendum 1");
        DocumentAct addendum2 = this.createAddendum("2015-07-04", this.patient, this.clinician, "Note 3 addendum 2");
        this.patientFactory.updateNote(note3).addAddenda(new DocumentAct[]{addendum1, addendum2}).build();
        this.createVisit("2015-07-01", "2015-07-02", this.patient, new Act[]{note3});
        DocumentAct note4 = this.createNote(treatFrom1, this.patient, this.clinician, "Note 4");
        this.createVisit(treatFrom1, treatTo1, this.patient, this.clinician, new Act[]{note4});
        Product product1 = this.productFactory.createMedication();
        Product product2 = this.productFactory.createMedication();
        Product product3 = this.productFactory.createMedication();
        Date itemDate1 = TestHelper.getDatetime((String)"2017-09-27 10:00:00");
        BigDecimal discount1 = new BigDecimal("0.10");
        BigDecimal discountTax1 = new BigDecimal("0.01");
        BigDecimal tax1 = new BigDecimal("0.08");
        BigDecimal total1 = new BigDecimal("0.90");
        FinancialAct invoiceItem1 = this.createInvoiceItem(itemDate1, product1, BigDecimal.ONE, BigDecimal.ONE, discount1, tax1);
        Date itemDate2 = TestHelper.getDatetime((String)"2017-09-27 11:00:00");
        BigDecimal discount2 = BigDecimal.ZERO;
        BigDecimal discountTax2 = BigDecimal.ZERO;
        BigDecimal tax2 = new BigDecimal("0.91");
        BigDecimal total2 = BigDecimal.TEN;
        FinancialAct invoiceItem2 = this.createInvoiceItem(itemDate2, product2, BigDecimal.ONE, BigDecimal.TEN, discount2, tax2);
        FinancialAct invoice1Act = this.createInvoice(TestHelper.getDate((String)"2017-09-27"), invoiceItem1, invoiceItem2);
        Date itemDate3 = TestHelper.getDatetime((String)"2017-09-28 15:00:00");
        BigDecimal discount3 = BigDecimal.ZERO;
        BigDecimal discountTax3 = BigDecimal.ZERO;
        BigDecimal tax3 = new BigDecimal("0.91");
        BigDecimal total3 = BigDecimal.TEN;
        FinancialAct invoiceItem3 = this.createInvoiceItem(itemDate3, product3, new BigDecimal("2"), new BigDecimal("5"), discount3, tax3);
        FinancialAct invoice2Act = this.createInvoice(TestHelper.getDate((String)"2017-09-28"), invoiceItem3);
        BigDecimal toPay = invoice1Act.getTotal().add(invoice2Act.getTotal());
        this.makePayment(toPay);
        context.setUser(this.user);
        Act claimAct = (Act)this.newClaim().claimId("actIdentity.insuranceClaim", "CLM987654").item().treatmentDates(treatFrom1, treatTo1).diagnosis("VENOM_328", "Abcess", "328").invoiceItems(new FinancialAct[]{invoiceItem1, invoiceItem2, invoiceItem3}).add().build();
        ClaimImpl claim = this.getClaim(claimAct);
        Assert.assertEquals((long)claimAct.getId(), (long)claim.getId());
        Assert.assertEquals((Object)"CLM987654", (Object)claim.getInsurerId());
        Assert.assertEquals((Object)Claim.Status.PENDING, (Object)claim.getStatus());
        Policy policy = claim.getPolicy();
        Assert.assertNotNull((Object)policy);
        Assert.assertEquals((Object)"POL123456", (Object)policy.getPolicyNumber());
        ClaimHandler handler = claim.getClaimHandler();
        Assert.assertNotNull((Object)handler);
        Assert.assertEquals((Object)this.user.getName(), (Object)handler.getName());
        Assert.assertEquals((Object)this.locationEmail, (Object)handler.getEmail());
        Assert.assertEquals((Object)this.locationPhone, (Object)handler.getPhone());
        Patient animal = claim.getAnimal();
        Assert.assertEquals((long)this.patient.getId(), (long)animal.getId());
        Assert.assertEquals((Object)this.patient.getName(), (Object)animal.getName());
        Assert.assertEquals((Object)this.dateOfBirth, (Object)DateRules.toDate((LocalDate)animal.getDateOfBirth()));
        Assert.assertEquals((Object)"Canine", (Object)animal.getSpeciesName());
        Assert.assertEquals((Object)"Pug", (Object)animal.getBreedName());
        Assert.assertEquals((Object)Patient.Sex.MALE, (Object)animal.getSex());
        Assert.assertEquals((Object)"Black", (Object)animal.getColourName());
        Assert.assertEquals((Object)"123454321", (Object)animal.getMicrochip().getIdentity());
        Assert.assertEquals((Object)this.patient.getCreated(), (Object)animal.getCreated());
        Assert.assertEquals((long)1L, (long)claim.getConditions().size());
        Condition condition1 = (Condition)claim.getConditions().get(0);
        this.checkCondition(condition1, TestHelper.getDate((String)treatFrom1), TestHelper.getDate((String)treatTo1), "VENOM_328");
        Assert.assertEquals((long)2L, (long)condition1.getInvoices().size());
        BigDecimal conditionDiscount = discount1.add(discount2).add(discount3);
        BigDecimal conditionDiscountTax = discountTax1.add(discountTax2).add(discountTax3);
        BigDecimal conditionTotal = total1.add(total2).add(total3);
        BigDecimal conditionTax = tax1.add(tax2).add(tax3);
        this.checkEquals(conditionDiscount, condition1.getDiscount());
        this.checkEquals(conditionDiscountTax, condition1.getDiscountTax());
        this.checkEquals(conditionTotal, condition1.getTotal());
        this.checkEquals(conditionTax, condition1.getTotalTax());
        Assert.assertNull((Object)condition1.getEuthanasiaReason());
        List notes = condition1.getConsultationNotes();
        Assert.assertEquals((long)1L, (long)notes.size());
        this.checkNote((Note)notes.get(0), TestHelper.getDate((String)treatFrom1), this.clinician, "Note 4", author, 0);
        Invoice invoice1 = (Invoice)condition1.getInvoices().get(0);
        this.checkInvoice(invoice1, invoice1Act.getId(), discount1.add(discount2), discountTax1.add(discountTax2), tax1.add(tax2), total1.add(total2));
        List items1 = invoice1.getItems();
        Assert.assertEquals((long)2L, (long)items1.size());
        this.checkItem((Item)items1.get(0), invoiceItem1.getId(), itemDate1, product1, discount1, discountTax1, tax1, total1);
        this.checkItem((Item)items1.get(1), invoiceItem2.getId(), itemDate2, product2, discount2, discountTax2, tax2, total2);
        Invoice invoice2 = (Invoice)condition1.getInvoices().get(1);
        this.checkInvoice(invoice2, invoice2Act.getId(), discount3, discountTax3, tax3, total3);
        List items2 = invoice2.getItems();
        Assert.assertEquals((long)1L, (long)items2.size());
        this.checkItem((Item)items2.get(0), invoiceItem3.getId(), itemDate3, product3, discount3, discountTax3, tax3, total3);
        this.checkEquals(conditionTotal, claim.getTotal());
        this.checkEquals(conditionTax, claim.getTotalTax());
        this.checkEquals(conditionDiscount, claim.getDiscount());
        this.checkEquals(discountTax1.add(discountTax2).add(discountTax3), claim.getDiscountTax());
        this.checkEquals(conditionTotal, claim.getCurrentPaid());
        this.checkEquals(BigDecimal.ZERO, claim.getCurrentBalance());
        List history = IterableUtils.toList((Iterable)claim.getHistory().getNotes());
        Assert.assertEquals((long)4L, (long)history.size());
        this.checkNote((Note)history.get(0), TestHelper.getDate((String)"2015-05-01"), this.clinician, "Note 1", author, 0);
        this.checkNote((Note)history.get(1), TestHelper.getDate((String)"2015-05-02"), this.clinician, "Note 2", author, 0);
        Note n3 = this.checkNote((Note)history.get(2), TestHelper.getDate((String)"2015-07-01"), this.clinician, "Note 3", author, 2);
        this.checkNote((Note)n3.getNotes().get(0), TestHelper.getDate((String)"2015-07-03"), this.clinician, "Note 3 addendum 1", author, 0);
        this.checkNote((Note)n3.getNotes().get(1), TestHelper.getDate((String)"2015-07-04"), this.clinician, "Note 3 addendum 2", author, 0);
        this.checkNote((Note)history.get(3), TestHelper.getDate((String)treatFrom1), this.clinician, "Note 4", author, 0);
    }

    @Test
    public void testGetHistory() {
        User author = this.userFactory.createUser();
        AuthenticationContextImpl context = new AuthenticationContextImpl();
        context.setUser(author);
        DocumentAct note1 = this.createNote("2015-05-01", this.patient, this.clinician, "Note 1");
        DocumentAct note2 = this.createNote("2015-05-02", this.patient, this.clinician, "Note 2");
        this.createVisit("2015-05-01", "2015-05-02", this.patient, new Act[]{note1, note2});
        DocumentAct note3 = this.createNote("2015-07-01", this.patient, this.clinician, "Note 3");
        DocumentAct addendum1 = this.createAddendum("2015-07-03", this.patient, this.clinician, "Note 3 addendum 1");
        DocumentAct addendum2 = this.createAddendum("2015-07-04", this.patient, this.clinician, "Note 3 addendum 2");
        this.patientFactory.updateNote(note3).addAddenda(new DocumentAct[]{addendum1, addendum2}).build();
        this.createVisit("2015-07-01", "2015-07-02", this.patient, new Act[]{note3});
        DocumentAct note4 = this.createNote("2017-09-27", this.patient, this.clinician, "Note 4");
        this.createVisit("2017-09-27", "2017-09-29", this.patient, this.clinician, new Act[]{note4});
        Entity insuranceService = this.insuranceFactory.createInsuranceService();
        this.insuranceFactory.updateInsurer(this.insurer1).insuranceService(insuranceService).build();
        Act claim1Act = (Act)this.newClaim().date("2017-10-02").item().treatmentDates("2017-10-01", "2017-10-02").add().status("SUBMITTED").build();
        ClaimImpl claim1 = this.getClaim(claim1Act);
        this.checkHistory(claim1.getHistory().getNotes(), new Act[]{note1, note2, note3, note4});
        this.checkHistory(claim1.getHistory().getNotesSinceLastClaim(), new Act[]{note1, note2, note3, note4});
        DocumentAct note5 = this.createNote("2024-01-01", this.patient, this.clinician, "Note 5");
        this.createVisit("2024-01-01", "2024-01-02", this.patient, this.clinician, new Act[]{note5});
        Act claim2Act = (Act)this.newClaim().date("2024-01-02").item().treatmentDates("2024-01-01", "2024-01-02").add().status("POSTED").build();
        ClaimImpl claim2 = this.getClaim(claim2Act);
        this.checkHistory(claim2.getHistory().getNotes(), new Act[]{note1, note2, note3, note4, note5});
        this.checkHistory(claim2.getHistory().getNotesSinceLastClaim(), new Act[]{note5});
        claim1Act.setStatus("CANCELLED");
        this.save((IMObject)claim1Act);
        this.checkHistory(claim2.getHistory().getNotes(), new Act[]{note1, note2, note3, note4, note5});
        this.checkHistory(claim2.getHistory().getNotesSinceLastClaim(), new Act[]{note1, note2, note3, note4, note5});
    }

    @Test
    public void testGetHistoryForOutOfOrderClaim() {
        User author = this.userFactory.createUser();
        AuthenticationContextImpl context = new AuthenticationContextImpl();
        context.setUser(author);
        Entity insuranceService = this.insuranceFactory.createInsuranceService();
        this.insuranceFactory.updateInsurer(this.insurer1).insuranceService(insuranceService).build();
        DocumentAct noteA = this.createNote("2015-05-01", this.patient, this.clinician, "Note A");
        this.createVisit("2015-05-01", "2015-05-02", this.patient, new Act[]{noteA});
        DocumentAct noteB = this.createNote("2015-05-03", this.patient, this.clinician, "Note B");
        this.createVisit("2015-05-03", "2015-05-04", this.patient, new Act[]{noteB});
        DocumentAct noteC = this.createNote("2015-07-01", this.patient, this.clinician, "Note C");
        this.createVisit("2015-07-01", "2015-07-02", this.patient, new Act[]{noteC});
        Act claim1Act = (Act)this.newClaim().item().treatmentDates("2015-05-03", "2015-05-04").add().status("SUBMITTED").build();
        ClaimImpl claim1 = this.getClaim(claim1Act);
        this.checkHistory(claim1.getHistory().getNotes(), new Act[]{noteA, noteB});
        this.checkHistory(claim1.getHistory().getNotesSinceLastClaim(), new Act[]{noteA, noteB});
        Act claim2Act = (Act)this.newClaim().item().treatmentDates("2015-07-01", "2015-07-02").add().status("SUBMITTED").build();
        ClaimImpl claim2 = this.getClaim(claim2Act);
        this.checkHistory(claim2.getHistory().getNotes(), new Act[]{noteA, noteB, noteC});
        this.checkHistory(claim2.getHistory().getNotesSinceLastClaim(), new Act[]{noteC});
        Act claim3Act = (Act)this.newClaim().item().treatmentDates("2015-05-01", "2015-05-02").add().status("SUBMITTED").build();
        ClaimImpl claim3 = this.getClaim(claim3Act);
        this.checkHistory(claim3.getHistory().getNotes(), new Act[]{noteA});
        this.checkHistory(claim3.getHistory().getNotesSinceLastClaim(), new Act[]{noteA});
    }

    @Test
    public void testGetHistoryWhereTreatmentDatesNotAlignedWithVisitDate() {
        User author = this.userFactory.createUser();
        AuthenticationContextImpl context = new AuthenticationContextImpl();
        context.setUser(author);
        Entity insuranceService = this.insuranceFactory.createInsuranceService();
        this.insuranceFactory.updateInsurer(this.insurer1).insuranceService(insuranceService).build();
        DocumentAct noteA = this.createNote("2015-05-01 10:00", this.patient, this.clinician, "Note A");
        this.createVisit("2015-05-01 10:00", "2015-05-02 10:00", this.patient, new Act[]{noteA});
        DocumentAct noteB = this.createNote("2015-05-03 11:00", this.patient, this.clinician, "Note B");
        this.createVisit("2015-05-03 10:00", "2015-05-04 12:00", this.patient, new Act[]{noteB});
        Act claim1Act = (Act)this.newClaim().item().treatmentDates("2015-05-03", "2015-05-04").add().status("SUBMITTED").build();
        ClaimImpl claim1 = this.getClaim(claim1Act);
        this.checkHistory(claim1.getHistory().getNotes(), new Act[]{noteA, noteB});
        this.checkHistory(claim1.getHistory().getNotesSinceLastClaim(), new Act[]{noteA, noteB});
        DocumentAct noteC = this.createNote("2016-01-03 11:00", this.patient, this.clinician, "Note C");
        this.createVisit("2016-01-03 10:00", "2016-01-03 12:00", this.patient, new Act[]{noteC});
        DocumentAct noteD = this.createNote("2016-02-03 11:00", this.patient, this.clinician, "Note D");
        this.createVisit("2016-02-03 10:00", "2016-02-03 12:00", this.patient, new Act[]{noteD});
        Act claim2Act = (Act)this.newClaim().item().treatmentDates("2016-01-03", "2016-01-03").add().status("SUBMITTED").build();
        ClaimImpl claim2 = this.getClaim(claim2Act);
        this.checkHistory(claim2.getHistory().getNotes(), new Act[]{noteA, noteB, noteC});
        this.checkHistory(claim2.getHistory().getNotesSinceLastClaim(), new Act[]{noteC});
    }

    @Test
    public void testGetHistoryWhereVisitStartEndDatesAreTheSame() {
        User author = this.userFactory.createUser();
        AuthenticationContextImpl context = new AuthenticationContextImpl();
        context.setUser(author);
        Entity insuranceService = this.insuranceFactory.createInsuranceService();
        this.insuranceFactory.updateInsurer(this.insurer1).insuranceService(insuranceService).build();
        DocumentAct noteA = this.createNote("2015-05-01 10:00", this.patient, this.clinician, "Note A");
        this.createVisit("2015-05-01", "2015-05-02", this.patient, new Act[]{noteA});
        DocumentAct noteB = this.createNote("2015-05-03 11:00", this.patient, this.clinician, "Note B");
        this.createVisit("2015-05-03", "2015-05-03", this.patient, new Act[]{noteB});
        Act claim1Act = (Act)this.newClaim().item().treatmentDates("2015-05-03", "2015-05-03").add().status("SUBMITTED").build();
        ClaimImpl claim1 = this.getClaim(claim1Act);
        this.checkHistory(claim1.getHistory().getNotes(), new Act[]{noteA, noteB});
        this.checkHistory(claim1.getHistory().getNotesSinceLastClaim(), new Act[]{noteA, noteB});
        DocumentAct noteC = this.createNote("2016-01-03 11:00", this.patient, this.clinician, "Note C");
        this.createVisit("2016-01-03", "2016-01-03", this.patient, new Act[]{noteC});
        DocumentAct noteD = this.createNote("2016-02-03 11:00", this.patient, this.clinician, "Note D");
        this.createVisit("2016-02-03", "2016-02-03", this.patient, new Act[]{noteD});
        Act claim2Act = (Act)this.newClaim().item().treatmentDates("2016-01-03", "2016-01-03").add().status("SUBMITTED").build();
        ClaimImpl claim2 = this.getClaim(claim2Act);
        this.checkHistory(claim2.getHistory().getNotes(), new Act[]{noteA, noteB, noteC});
        this.checkHistory(claim2.getHistory().getNotesSinceLastClaim(), new Act[]{noteC});
    }

    @Test
    public void testGetHistoryForVisitWithNoEndTime() {
        User author = this.userFactory.createUser();
        AuthenticationContextImpl context = new AuthenticationContextImpl();
        context.setUser(author);
        Entity insuranceService = this.insuranceFactory.createInsuranceService();
        this.insuranceFactory.updateInsurer(this.insurer1).insuranceService(insuranceService).build();
        DocumentAct noteA = this.createNote("2015-05-01 10:00", this.patient, this.clinician, "Note A");
        Act visit1 = this.createVisit("2015-05-01", null, this.patient, new Act[]{noteA});
        Assert.assertNull((Object)visit1.getActivityEndTime());
        Act claim1Act = (Act)this.newClaim().item().treatmentDates("2015-05-01", "2015-05-02").add().status("SUBMITTED").build();
        ClaimImpl claim1 = this.getClaim(claim1Act);
        this.checkHistory(claim1.getHistory().getNotes(), new Act[]{noteA});
        this.checkHistory(claim1.getHistory().getNotesSinceLastClaim(), new Act[]{noteA});
        DocumentAct noteB = this.createNote("2015-05-03 11:00", this.patient, this.clinician, "Note B");
        Act visit2 = this.createVisit("2015-05-03", null, this.patient, new Act[]{noteB});
        Assert.assertNull((Object)visit2.getActivityEndTime());
        Act claim2Act = (Act)this.newClaim().item().treatmentDates("2015-05-03", "2015-05-03").add().status("SUBMITTED").build();
        ClaimImpl claim2 = this.getClaim(claim2Act);
        this.checkHistory(claim2.getHistory().getNotes(), new Act[]{noteA, noteB});
        this.checkHistory(claim2.getHistory().getNotesSinceLastClaim(), new Act[]{noteB});
    }

    @Test
    public void testCancel() {
        Product product1 = this.productFactory.createService();
        Date itemDate1 = TestHelper.getDatetime((String)"2017-09-27 10:00:00");
        BigDecimal discount1 = new BigDecimal("0.10");
        BigDecimal tax1 = new BigDecimal("0.08");
        FinancialAct invoiceItem1 = this.createInvoiceItem(itemDate1, product1, BigDecimal.ONE, BigDecimal.ONE, discount1, tax1);
        this.createInvoice(TestHelper.getDate((String)"2017-09-27"), invoiceItem1);
        Act claimAct = this.createClaim(invoiceItem1);
        ClaimImpl claim = this.getClaim(claimAct);
        Assert.assertEquals((Object)Claim.Status.PENDING, (Object)claim.getStatus());
        Assert.assertTrue((boolean)claim.canCancel());
        claim.setStatus(Claim.Status.POSTED);
        Assert.assertTrue((boolean)claim.canCancel());
        claim.setStatus(Claim.Status.SUBMITTED);
        Assert.assertTrue((boolean)claim.canCancel());
        claim.setStatus(Claim.Status.ACCEPTED);
        Assert.assertTrue((boolean)claim.canCancel());
        claim.setStatus(Claim.Status.SETTLED);
        Assert.assertFalse((boolean)claim.canCancel());
        claimAct.setStatus(Claim.Status.DECLINED.toString());
        Assert.assertFalse((boolean)claim.canCancel());
        claimAct.setStatus(Claim.Status.CANCELLING.toString());
        Assert.assertFalse((boolean)claim.canCancel());
        claim.setStatus(Claim.Status.CANCELLED);
        Assert.assertFalse((boolean)claim.canCancel());
    }

    @Test
    public void testDeleteClaim() {
        Product product1 = this.productFactory.createService();
        Date itemDate1 = TestHelper.getDatetime((String)"2017-09-27 10:00:00");
        BigDecimal discount1 = new BigDecimal("0.10");
        BigDecimal tax1 = new BigDecimal("0.08");
        FinancialAct invoiceItem1 = this.createInvoiceItem(itemDate1, product1, BigDecimal.ONE, BigDecimal.ONE, discount1, tax1);
        FinancialAct invoice1 = this.createInvoice(TestHelper.getDate((String)"2017-09-27"), invoiceItem1);
        Act claimAct = this.createClaim(invoiceItem1);
        IMObjectBean bean = this.getBean((IMObject)claimAct);
        List items = bean.getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)1L, (long)items.size());
        DocumentAct documentAct = PatientTestHelper.createDocumentAttachment((Date)itemDate1, (Party)this.patient);
        DocumentAct attachment = InsuranceTestHelper.createAttachment((DocumentAct)documentAct);
        Document content = (Document)this.create("document.other", Document.class);
        content.setName(documentAct.getName());
        attachment.setDocument((Reference)content.getObjectReference());
        bean.addTarget("attachments", (IMObject)attachment, "claim");
        this.save((IMObject[])new AuditableIMObject[]{claimAct, attachment, content});
        this.remove((IMObject)claimAct);
        Assert.assertNull((Object)this.get((IMObject)claimAct));
        Assert.assertNull((Object)this.get((IMObject)items.get(0)));
        Assert.assertNull((Object)this.get((IMObject)attachment));
        Assert.assertNotNull((Object)this.get((IMObject)content));
        Assert.assertNotNull((Object)this.get((IMObject)documentAct));
        Assert.assertNotNull((Object)this.get((IMObject)this.policyAct));
        Assert.assertNotNull((Object)this.get((IMObject)invoiceItem1));
        Assert.assertNotNull((Object)this.get((IMObject)invoice1));
    }

    @Test
    public void testSetPolicy() {
        Act claimAct1 = this.createClaim(new FinancialAct[0]);
        Party insurer2 = this.insuranceFactory.createInsurer();
        ClaimImpl claim1 = this.getClaim(claimAct1);
        Policy existing = claim1.getPolicy();
        Policy update1 = claim1.setPolicy(this.insurer1, "POL123456");
        Assert.assertEquals((Object)existing, (Object)update1);
        this.checkPolicy(update1, this.insurer1, "POL123456");
        Policy update2 = claim1.setPolicy(insurer2, "POL123456");
        Assert.assertNotEquals((Object)update1, (Object)update2);
        Assert.assertEquals((long)existing.getId(), (long)update2.getId());
        this.checkPolicy(update2, insurer2, "POL123456");
        Policy update3 = claim1.setPolicy(insurer2, "POL987654");
        Assert.assertNotEquals((Object)update2, (Object)update3);
        Assert.assertEquals((long)existing.getId(), (long)update3.getId());
        this.checkPolicy(update3, insurer2, "POL987654");
        this.policyAct = (Act)this.get((IMObject)this.policyAct);
        this.insuranceFactory.newClaim().policy(this.policyAct).location(this.location).clinician(this.clinician).claimHandler(this.user).item().diagnosis("VENOM_328", "Abcess", "328").add().build();
        claim1 = this.getClaim(claimAct1);
        Policy update4 = claim1.setPolicy(insurer2, "POL1111111");
        Assert.assertNotEquals((Object)update3, (Object)update4);
        Assert.assertEquals((long)existing.getId(), (long)update3.getId());
        Assert.assertNotEquals((long)update4.getId(), (long)this.policyAct.getId());
        this.checkPolicy(update4, insurer2, "POL1111111");
    }

    @Test
    public void testCurrentPaidForSingleInvoice() {
        FinancialAct invoiceItem1 = this.createInvoiceItem(BigDecimal.TEN);
        FinancialAct invoice = this.createInvoice(invoiceItem1);
        Act claimAct = this.createClaim(invoiceItem1);
        ClaimImpl claim1 = this.getClaim(claimAct);
        this.checkCurrentPaid((Claim)claim1, BigDecimal.ZERO, BigDecimal.TEN);
        Assert.assertEquals((long)1L, (long)claim1.getConditions().size());
        this.checkCurrentPaid((Condition)claim1.getConditions().get(0), BigDecimal.ZERO, BigDecimal.TEN);
        this.checkEquals(BigDecimal.ZERO, claim1.getInvoiceAllocation());
        this.makePayment(invoice.getTotal());
        ClaimImpl claim2 = this.getClaim(claimAct);
        this.checkCurrentPaid((Claim)claim2, BigDecimal.TEN, BigDecimal.ZERO);
        Assert.assertEquals((long)1L, (long)claim2.getConditions().size());
        this.checkCurrentPaid((Condition)claim2.getConditions().get(0), BigDecimal.TEN, BigDecimal.ZERO);
        this.checkEquals(BigDecimal.TEN, claim2.getInvoiceAllocation());
    }

    @Test
    public void testCurrentPaidForSinglePartiallyClaimedInvoice() {
        FinancialAct invoiceItem1 = this.createInvoiceItem(BigDecimal.TEN);
        FinancialAct invoiceItem2 = this.createInvoiceItem(BigDecimal.TEN);
        FinancialAct invoice = this.createInvoice(invoiceItem1, invoiceItem2);
        Act claimAct = this.createClaim(invoiceItem1);
        ClaimImpl claim1 = this.getClaim(claimAct);
        this.checkCurrentPaid((Claim)claim1, BigDecimal.ZERO, BigDecimal.TEN);
        Assert.assertEquals((long)1L, (long)claim1.getConditions().size());
        this.checkCurrentPaid((Condition)claim1.getConditions().get(0), BigDecimal.ZERO, BigDecimal.TEN);
        this.checkEquals(BigDecimal.ZERO, claim1.getInvoiceAllocation());
        this.makePayment(invoice.getTotal());
        ClaimImpl claim2 = this.getClaim(claimAct);
        this.checkCurrentPaid((Claim)claim2, BigDecimal.TEN, BigDecimal.ZERO);
        Assert.assertEquals((long)1L, (long)claim2.getConditions().size());
        this.checkCurrentPaid((Condition)claim2.getConditions().get(0), BigDecimal.TEN, BigDecimal.ZERO);
        this.checkEquals(invoice.getTotal(), claim2.getInvoiceAllocation());
    }

    @Test
    public void testCurrentPaidForMultipleInvoiceOnSingleCondition() {
        FinancialAct invoiceItem1 = this.createInvoiceItem(BigDecimal.TEN);
        this.createInvoice(invoiceItem1);
        FinancialAct invoiceItem2 = this.createInvoiceItem(BigDecimal.TEN);
        this.createInvoice(invoiceItem2);
        Act claimAct = this.createClaim(invoiceItem1, invoiceItem2);
        ClaimImpl claim1 = this.getClaim(claimAct);
        int total = 20;
        this.checkCurrentPaid((Claim)claim1, 0, total);
        Assert.assertEquals((long)1L, (long)claim1.getConditions().size());
        this.checkCurrentPaid((Condition)claim1.getConditions().get(0), 0, total);
        this.checkEquals(BigDecimal.ZERO, claim1.getInvoiceAllocation());
        this.makePayment(total);
        ClaimImpl claim2 = this.getClaim(claimAct);
        this.checkCurrentPaid((Claim)claim2, total, 0);
        Assert.assertEquals((long)1L, (long)claim2.getConditions().size());
        this.checkCurrentPaid((Condition)claim2.getConditions().get(0), total, 0);
        this.checkEquals(20, claim2.getInvoiceAllocation());
    }

    @Test
    public void testCurrentPaidForSingleInvoiceOnMultipleCondition() {
        FinancialAct invoiceItem1 = this.createInvoiceItem(BigDecimal.TEN);
        FinancialAct invoiceItem2 = this.createInvoiceItem(BigDecimal.TEN);
        this.createInvoice(invoiceItem1, invoiceItem2);
        Act claimAct = (Act)this.newClaim().item(new FinancialAct[]{invoiceItem1}).item(new FinancialAct[]{invoiceItem2}).build();
        ClaimImpl claim1 = this.getClaim(claimAct);
        int total = 20;
        this.checkCurrentPaid((Claim)claim1, 0, total);
        Assert.assertEquals((long)2L, (long)claim1.getConditions().size());
        this.checkCurrentPaid((Condition)claim1.getConditions().get(0), BigDecimal.ZERO, BigDecimal.TEN);
        this.checkCurrentPaid((Condition)claim1.getConditions().get(1), BigDecimal.ZERO, BigDecimal.TEN);
        this.checkEquals(BigDecimal.ZERO, claim1.getInvoiceAllocation());
        this.makePayment(total);
        ClaimImpl claim2 = this.getClaim(claimAct);
        this.checkCurrentPaid((Claim)claim2, total, 0);
        Assert.assertEquals((long)2L, (long)claim2.getConditions().size());
        this.checkCurrentPaid((Condition)claim2.getConditions().get(0), BigDecimal.TEN, BigDecimal.ZERO);
        this.checkCurrentPaid((Condition)claim2.getConditions().get(1), BigDecimal.TEN, BigDecimal.ZERO);
        this.checkEquals(total, claim2.getInvoiceAllocation());
    }

    @Test
    public void testCurrentPaidForSingleInvoiceOnMultipleClaims() {
        FinancialAct invoiceItem1 = this.createInvoiceItem(BigDecimal.TEN);
        int five = 5;
        FinancialAct invoiceItem2 = this.createInvoiceItem(five);
        this.createInvoice(invoiceItem1, invoiceItem2);
        int total = 15;
        this.makePayment(total);
        Act claim1Act = (Act)this.newClaim().item(new FinancialAct[]{invoiceItem1}).status("POSTED").build();
        Act claim2Act = (Act)this.newClaim().item(new FinancialAct[]{invoiceItem2}).build();
        ClaimImpl claim1 = this.getClaim(claim1Act);
        this.checkCurrentPaid((Claim)claim1, BigDecimal.TEN, BigDecimal.ZERO);
        Assert.assertEquals((long)1L, (long)claim1.getConditions().size());
        this.checkCurrentPaid((Condition)claim1.getConditions().get(0), BigDecimal.TEN, BigDecimal.ZERO);
        this.checkEquals(total, claim1.getInvoiceAllocation());
        ClaimImpl claim2 = this.getClaim(claim2Act);
        this.checkCurrentPaid((Claim)claim2, five, 0);
        Assert.assertEquals((long)1L, (long)claim2.getConditions().size());
        this.checkCurrentPaid((Condition)claim2.getConditions().get(0), five, 0);
        this.checkEquals(five, claim2.getInvoiceAllocation());
    }

    @Test
    public void testCurrentPaidForSingleInvoiceOnMultipleClaimsPartialPayment() {
        FinancialAct invoiceItem1 = this.createInvoiceItem(BigDecimal.TEN);
        int five = 5;
        FinancialAct invoiceItem2 = this.createInvoiceItem(five);
        this.createInvoice(invoiceItem1, invoiceItem2);
        int paid = 7;
        this.makePayment(paid);
        Act claim1Act = (Act)this.newClaim().item(new FinancialAct[]{invoiceItem1}).status("POSTED").build();
        Act claim2Act = (Act)this.newClaim().item(new FinancialAct[]{invoiceItem2}).build();
        ClaimImpl claim1 = this.getClaim(claim1Act);
        int balance = 3;
        this.checkCurrentPaid((Claim)claim1, paid, balance);
        Assert.assertEquals((long)1L, (long)claim1.getConditions().size());
        this.checkCurrentPaid((Condition)claim1.getConditions().get(0), paid, balance);
        this.checkEquals(paid, claim1.getInvoiceAllocation());
        ClaimImpl claim2 = this.getClaim(claim2Act);
        this.checkCurrentPaid((Claim)claim2, 0, five);
        Assert.assertEquals((long)1L, (long)claim2.getConditions().size());
        this.checkCurrentPaid((Condition)claim2.getConditions().get(0), 0, five);
        this.checkEquals(0, claim2.getInvoiceAllocation());
    }

    @Test
    public void testCurrentPaidForSingleInvoiceMultipleClaimsWithNegativeItem() {
        FinancialAct invoiceItem1 = this.createInvoiceItem(BigDecimal.TEN);
        FinancialAct invoiceItem2 = this.createInvoiceItem(BigDecimal.TEN);
        FinancialAct invoiceItem3 = this.createInvoiceItem(-5);
        this.createInvoice(invoiceItem1, invoiceItem2, invoiceItem3);
        int claim2Total = 5;
        int total = 15;
        this.makePayment(total);
        Act claim1Act = (Act)this.newClaim().item(new FinancialAct[]{invoiceItem1}).status("POSTED").build();
        Act claim2Act = (Act)this.newClaim().item(new FinancialAct[]{invoiceItem2, invoiceItem3}).build();
        ClaimImpl claim1 = this.getClaim(claim1Act);
        this.checkCurrentPaid((Claim)claim1, invoiceItem1.getTotal(), BigDecimal.ZERO);
        Assert.assertEquals((long)1L, (long)claim1.getConditions().size());
        this.checkCurrentPaid((Condition)claim1.getConditions().get(0), invoiceItem1.getTotal(), BigDecimal.ZERO);
        this.checkEquals(total, claim1.getInvoiceAllocation());
        ClaimImpl claim2 = this.getClaim(claim2Act);
        this.checkCurrentPaid((Claim)claim2, claim2Total, 0);
        this.checkCurrentPaid((Condition)claim2.getConditions().get(0), claim2Total, 0);
        this.checkEquals(claim2Total, claim2.getInvoiceAllocation());
    }

    @Test
    public void testCurrentPaidForNegativeInvoice() {
        FinancialAct invoiceItem1 = this.createInvoiceItem(BigDecimal.TEN);
        FinancialAct invoiceItem2 = this.createInvoiceItem(-1);
        this.createInvoice(invoiceItem1);
        this.createInvoice(invoiceItem2);
        int total = 9;
        this.makePayment(total);
        Act claimAct = (Act)this.newClaim().item(new FinancialAct[]{invoiceItem1, invoiceItem2}).build();
        ClaimImpl claim = this.getClaim(claimAct);
        this.checkCurrentPaid((Claim)claim, total, 0);
        Assert.assertEquals((long)1L, (long)claim.getConditions().size());
        this.checkCurrentPaid((Condition)claim.getConditions().get(0), total, 0);
        this.checkEquals(total, claim.getInvoiceAllocation());
    }

    @Test
    public void testCurrentPaidForCancelledPriorClaim() {
        FinancialAct invoiceItem1 = this.createInvoiceItem(BigDecimal.TEN);
        this.createInvoice(invoiceItem1);
        int four = 4;
        int six = 6;
        this.makePayment(six);
        Act cancelledClaim = (Act)this.newClaim().item(new FinancialAct[]{invoiceItem1}).status("CANCELLED").build();
        Assert.assertEquals((Object)"CANCELLED", (Object)cancelledClaim.getStatus());
        Act claimAct = (Act)this.newClaim().item(new FinancialAct[]{invoiceItem1}).build();
        ClaimImpl claim1 = this.getClaim(claimAct);
        this.checkCurrentPaid((Claim)claim1, six, four);
        Assert.assertEquals((long)1L, (long)claim1.getConditions().size());
        this.checkCurrentPaid((Condition)claim1.getConditions().get(0), six, four);
        this.checkEquals(6, claim1.getInvoiceAllocation());
    }

    private Act createClaim(FinancialAct ... invoiceItems) {
        return (Act)this.newClaim().item(invoiceItems).build();
    }

    private void checkCurrentPaid(Claim claim, int expectedPaid, int expectedBalance) {
        this.checkCurrentPaid(claim, BigDecimal.valueOf(expectedPaid), BigDecimal.valueOf(expectedBalance));
    }

    private void checkCurrentPaid(Claim claim, BigDecimal expectedPaid, BigDecimal expectedBalance) {
        this.checkEquals(expectedPaid, claim.getCurrentPaid());
        this.checkEquals(expectedBalance, claim.getCurrentBalance());
    }

    private void checkCurrentPaid(Condition condition, int expectedPaid, int expectedBalance) {
        this.checkCurrentPaid(condition, BigDecimal.valueOf(expectedPaid), BigDecimal.valueOf(expectedBalance));
    }

    private void checkCurrentPaid(Condition condition, BigDecimal expectedPaid, BigDecimal expectedBalance) {
        this.checkEquals(expectedPaid, condition.getCurrentPaid());
        this.checkEquals(expectedBalance, condition.getCurrentBalance());
    }

    private void makePayment(int amount) {
        this.makePayment(BigDecimal.valueOf(amount));
    }

    private void makePayment(BigDecimal amount) {
        ((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(this.customer)).till(this.practiceFactory.createTill())).cash(amount).build();
    }

    private void checkCondition(Condition condition, Date treatedFrom, Date treatedTo, String diagnosis) {
        Assert.assertEquals((Object)treatedFrom, (Object)DateRules.toDate((OffsetDateTime)condition.getTreatedFrom()));
        Assert.assertEquals((Object)treatedTo, (Object)DateRules.toDate((OffsetDateTime)condition.getTreatedTo()));
        Lookup lookup = condition.getDiagnosis();
        Assert.assertNotNull((Object)lookup);
        Assert.assertEquals((Object)diagnosis, (Object)lookup.getCode());
    }

    private Note checkNote(Note note, Date date, User clinician, String text, User author, int notes) {
        Assert.assertEquals((long)0L, (long)DateRules.compareTo((Date)date, (Date)DateRules.toDate((OffsetDateTime)note.getDate())));
        Assert.assertEquals((Object)clinician, (Object)note.getClinician());
        Assert.assertEquals((Object)text, (Object)note.getText());
        Assert.assertEquals((long)notes, (long)note.getNotes().size());
        Assert.assertEquals((Object)author, (Object)note.getAuthor());
        return note;
    }

    private void checkInvoice(Invoice invoice, long id, BigDecimal discount, BigDecimal discountTax, BigDecimal tax, BigDecimal total) {
        Assert.assertEquals((long)id, (long)invoice.getId());
        this.checkEquals(discount, invoice.getDiscount());
        this.checkEquals(discountTax, invoice.getDiscountTax());
        this.checkEquals(tax, invoice.getTotalTax());
        this.checkEquals(total, invoice.getTotal());
    }

    private void checkItem(Item item, long id, Date date, Product product, BigDecimal discount, BigDecimal discountTax, BigDecimal tax, BigDecimal total) {
        Assert.assertEquals((long)id, (long)item.getId());
        Assert.assertEquals((Object)date, (Object)DateRules.toDate((OffsetDateTime)item.getDate()));
        Assert.assertEquals((Object)product, (Object)item.getProduct());
        this.checkEquals(discount, item.getDiscount());
        this.checkEquals(discountTax, item.getDiscountTax());
        this.checkEquals(tax, item.getTotalTax());
        this.checkEquals(total, item.getTotal());
    }

    private void checkHistory(Iterable<Note> history, Act ... expected) {
        List actual = IterableUtils.toList(history);
        Assert.assertEquals((long)expected.length, (long)actual.size());
        for (int i = 0; i < actual.size(); ++i) {
            this.checkNote(expected[i], (Note)actual.get(i));
        }
    }

    private void checkNote(Act expected, Note actual) {
        List expectedAddenda;
        User author = (User)this.get(expected.getCreatedBy(), User.class);
        Assert.assertNotNull((Object)author);
        IMObjectBean bean = this.getBean((IMObject)expected);
        if (expected.isA("act.patientClinicalNote")) {
            expectedAddenda = bean.getTargets("addenda", Act.class);
            expectedAddenda.sort(ActComparator.ascending());
        } else {
            expectedAddenda = Collections.emptyList();
        }
        Note note = this.checkNote(actual, expected.getActivityStartTime(), this.clinician, bean.getString("note"), author, expectedAddenda.size());
        if (!expectedAddenda.isEmpty()) {
            List actualAddenda = note.getNotes();
            Assert.assertEquals((long)expectedAddenda.size(), (long)actualAddenda.size());
            for (int i = 0; i < actualAddenda.size(); ++i) {
                this.checkNote((Act)expectedAddenda.get(i), (Note)actualAddenda.get(i));
            }
        }
    }

    private Act createVisit(String startTime, String endTime, Party patient, Act ... items) {
        return this.createVisit(startTime, endTime, patient, (User)null, items);
    }

    private Act createVisit(String startTime, String endTime, Party patient, User clinician, Act ... items) {
        return (Act)((TestVisitBuilder)((TestVisitBuilder)((TestVisitBuilder)((TestVisitBuilder)this.patientFactory.newVisit().startTime(startTime)).endTime(endTime)).patient(patient)).clinician(clinician)).addItems(items).build();
    }

    private DocumentAct createNote(String date, Party patient, User clinician, String note) {
        return (DocumentAct)((TestNoteBuilder)((TestNoteBuilder)((TestNoteBuilder)((TestNoteBuilder)this.patientFactory.newNote().startTime(date)).patient(patient)).clinician(clinician)).note(note)).build();
    }

    private DocumentAct createAddendum(String date, Party patient, User clinician, String note) {
        return (DocumentAct)((TestAddendumBuilder)((TestAddendumBuilder)((TestAddendumBuilder)((TestAddendumBuilder)this.patientFactory.newAddendum().startTime(date)).patient(patient)).clinician(clinician)).note(note)).build();
    }
}

