/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.internal.service;

import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.insurance.exception.InsuranceException;
import org.openvpms.insurance.internal.i18n.InsuranceMessages;
import org.openvpms.insurance.service.InsuranceService;
import org.openvpms.insurance.service.InsuranceServices;
import org.openvpms.plugin.manager.PluginManager;

public class InsuranceServicesImpl
implements InsuranceServices {
    private final PluginManager manager;
    private final IArchetypeRuleService service;

    public InsuranceServicesImpl(PluginManager manager, IArchetypeRuleService service) {
        this.manager = manager;
        this.service = service;
    }

    public boolean canSubmit(Party insurer) {
        return this.getConfig(insurer) != null;
    }

    public InsuranceService getServiceForConfiguration(Entity config) {
        InsuranceService result = null;
        String archetype = config.getArchetype();
        for (InsuranceService insuranceService : this.manager.getServices(InsuranceService.class)) {
            if (!archetype.equals(insuranceService.getArchetype())) continue;
            result = insuranceService;
            break;
        }
        if (result == null) {
            throw new InsuranceException(InsuranceMessages.serviceUnavailable(config.getName()));
        }
        return result;
    }

    public InsuranceService getService(Party insurer) {
        InsuranceService result = null;
        Entity config = this.getConfig(insurer);
        if (config != null) {
            result = this.getServiceForConfiguration(config);
        }
        return result;
    }

    private Entity getConfig(Party insurer) {
        IMObjectBean bean = this.service.getBean((IMObject)insurer);
        Entity config = (Entity)bean.getTarget("service", Entity.class);
        if (config != null && !config.isActive()) {
            throw new InsuranceException(InsuranceMessages.serviceInactive(config.getName(), insurer.getName()));
        }
        return config;
    }
}

