/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.internal.policy;

import java.time.OffsetDateTime;
import java.util.Date;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Identity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.internal.customer.CustomerImpl;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.patient.PatientImpl;
import org.openvpms.domain.patient.Patient;
import org.openvpms.insurance.exception.InsuranceException;
import org.openvpms.insurance.internal.i18n.InsuranceMessages;
import org.openvpms.insurance.policy.Policy;

public class PolicyImpl
implements Policy {
    private final IMObjectBean policy;
    private final Act act;
    private final CustomerRules customerRules;
    private final PatientRules patientRules;
    private final DomainService domainService;
    private Party customer;
    private Customer policyHolder;
    private Patient animal;
    private Party insurer;

    public PolicyImpl(Act policy, ArchetypeService service, CustomerRules customerRules, PatientRules patientRules, DomainService domainService) {
        this.policy = service.getBean((IMObject)policy);
        this.act = policy;
        this.customerRules = customerRules;
        this.patientRules = patientRules;
        this.domainService = domainService;
    }

    public long getId() {
        return this.policy.getObject().getId();
    }

    public String getPolicyNumber() {
        Identity insurerId = (Identity)this.policy.getObject("insurerId", Identity.class);
        return insurerId != null ? insurerId.getIdentity() : null;
    }

    public OffsetDateTime getExpiryDate() {
        return DateRules.toOffsetDateTime((Date)this.act.getActivityEndTime());
    }

    public Customer getPolicyHolder() {
        if (this.policyHolder == null) {
            this.customer = (Party)this.policy.getTarget("customer", Party.class);
            if (this.customer == null) {
                throw new InsuranceException(InsuranceMessages.policyHasNoCustomer());
            }
            this.policyHolder = new CustomerImpl(this.customer, this.customerRules, this.domainService);
        }
        return this.policyHolder;
    }

    public Patient getAnimal() {
        if (this.animal == null) {
            Party patient = this.getPatient();
            this.animal = new PatientImpl(patient, this.patientRules, this.domainService);
        }
        return this.animal;
    }

    public Party getInsurer() {
        if (this.insurer == null) {
            this.insurer = (Party)this.policy.getTarget("insurer", Party.class);
            if (this.insurer == null) {
                throw new InsuranceException(InsuranceMessages.policyHasNoInsurer());
            }
        }
        return this.insurer;
    }

    public Act getAct() {
        return this.act;
    }

    public Party getCustomer() {
        this.getPolicyHolder();
        return this.customer;
    }

    public Party getPatient() {
        Party patient = (Party)this.policy.getTarget("patient", Party.class);
        if (patient == null) {
            throw new InsuranceException(InsuranceMessages.policyHasNoPatient());
        }
        return patient;
    }
}

