/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.internal.claim;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.Reference;
import org.openvpms.insurance.claim.Invoice;
import org.openvpms.insurance.claim.Item;

public class InvoiceImpl
implements Invoice {
    private final Reference reference;
    private final Date date;
    private final List<Item> items;

    public InvoiceImpl(FinancialAct invoice, List<Item> items) {
        this.reference = invoice.getObjectReference();
        this.date = invoice.getActivityStartTime();
        this.items = items;
    }

    public long getId() {
        return this.reference.getId();
    }

    public OffsetDateTime getDate() {
        return DateRules.toOffsetDateTime((Date)this.date);
    }

    public BigDecimal getDiscount() {
        BigDecimal result = BigDecimal.ZERO;
        for (Item item : this.items) {
            result = result.add(item.getDiscount());
        }
        return result;
    }

    public BigDecimal getDiscountTax() {
        BigDecimal result = BigDecimal.ZERO;
        for (Item item : this.items) {
            result = result.add(item.getDiscountTax());
        }
        return result;
    }

    public BigDecimal getTotal() {
        BigDecimal result = BigDecimal.ZERO;
        for (Item item : this.items) {
            result = result.add(item.getTotal());
        }
        return result;
    }

    public BigDecimal getTotalTax() {
        BigDecimal result = BigDecimal.ZERO;
        for (Item item : this.items) {
            result = result.add(item.getTotalTax());
        }
        return result;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public Reference getObjectReference() {
        return this.reference;
    }
}

