/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.internal.claim;

import java.util.Date;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.insurance.claim.History;
import org.openvpms.insurance.claim.Note;
import org.openvpms.insurance.internal.claim.NotesQuery;

public class HistoryImpl
implements History {
    private final Party patient;
    private final Party insurer;
    private final Act claim;
    private final Reference location;
    private final Date minTreatmentDate;
    private final Date maxTreatmentDate;
    private final MedicalRecordRules recordRules;
    private Date fromDate;
    private final InsuranceRules insuranceRules;
    private Date toDate;
    private boolean inclusive;
    private final NotesQuery query;
    private static final int PAGE_SIZE = 100;

    public HistoryImpl(Party patient, Party insurer, Act claim, Date minTreatmentDate, Date maxTreatmentDate, InsuranceRules insuranceRules, MedicalRecordRules recordRules, ArchetypeService service) {
        this.patient = patient;
        this.insurer = insurer;
        this.claim = claim;
        this.location = service.getBean((IMObject)claim).getTargetRef("location");
        this.minTreatmentDate = minTreatmentDate;
        this.maxTreatmentDate = maxTreatmentDate;
        this.insuranceRules = insuranceRules;
        this.recordRules = recordRules;
        this.query = new NotesQuery(service);
    }

    public Iterable<Note> getNotes() {
        return this.query.query(this.patient, null, false, this.getTreatedTo(), this.isTreatedToInclusive(), 100);
    }

    public Iterable<Note> getNotesSinceLastClaim() {
        Date prior = this.getPriorTreatmentDate();
        boolean inclusiveFrom = false;
        if (prior != null && this.fromDate != null) {
            inclusiveFrom = DateRules.compareTo((Date)prior, (Date)this.fromDate) == 0;
        }
        return this.query.query(this.patient, prior, inclusiveFrom, this.getTreatedTo(), this.isTreatedToInclusive(), 100);
    }

    public Date getPriorTreatmentDate() {
        return this.insuranceRules.getPriorTreatmentDate(this.patient, this.insurer, this.claim, this.getTreatedFrom());
    }

    public Date getTreatedFrom() {
        this.initTreatedDates();
        return this.fromDate;
    }

    public Date getTreatedTo() {
        this.initTreatedDates();
        return this.toDate;
    }

    public boolean isTreatedToInclusive() {
        this.initTreatedDates();
        return this.inclusive;
    }

    private void initTreatedDates() {
        if (this.fromDate == null) {
            Act visit1 = this.recordRules.getEvent(this.patient.getObjectReference(), this.minTreatmentDate, this.location);
            if (visit1 != null) {
                this.fromDate = visit1.getActivityStartTime();
                Date to = visit1.getActivityEndTime();
                if (this.maxTreatmentDate == null) {
                    this.toDate = to;
                    this.inclusive = true;
                } else if (to != null) {
                    if (DateRules.compareTo((Date)this.maxTreatmentDate, (Date)to, (boolean)true) <= 0) {
                        this.toDate = to;
                        this.inclusive = true;
                    } else {
                        Act visit2 = this.recordRules.getEvent(this.patient.getObjectReference(), this.maxTreatmentDate, this.location);
                        if (visit2 != null && visit2.getActivityEndTime() != null) {
                            this.toDate = visit2.getActivityEndTime();
                            this.inclusive = visit2.getActivityStartTime() != null && visit2.getActivityStartTime().equals(this.toDate);
                        } else {
                            this.toDate = this.maxTreatmentDate;
                        }
                    }
                } else {
                    this.toDate = this.maxTreatmentDate;
                }
            } else {
                this.fromDate = this.minTreatmentDate;
                this.toDate = this.maxTreatmentDate;
            }
            if (!this.inclusive && this.fromDate != null && this.toDate != null) {
                this.inclusive = DateRules.compareTo((Date)this.fromDate, (Date)this.toDate, (boolean)true) == 0;
            }
        }
    }
}

