/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.internal.claim;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.patient.TestAttachmentBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.insurance.internal.claim.AttachmentImpl;
import org.springframework.beans.factory.annotation.Autowired;

public class AttachmentImplTestCase
extends ArchetypeServiceTest {
    @Autowired
    private DocumentHandlers documentHandlers;
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestPatientFactory patientFactory;

    @Test
    public void testAccessors() throws Exception {
        Document image = this.documentFactory.createImage();
        Assert.assertTrue((image.getSize() > 0 ? 1 : 0) != 0);
        DocumentAct act = (DocumentAct)((TestAttachmentBuilder)((TestAttachmentBuilder)this.patientFactory.newAttachment().patient(this.patientFactory.createPatient())).document(image)).build();
        AttachmentImpl attachment = new AttachmentImpl(act, (ArchetypeService)this.getArchetypeService(), this.documentHandlers);
        Assert.assertEquals((Object)"image.png", (Object)attachment.getFileName());
        Assert.assertEquals((Object)"image/png", (Object)attachment.getMimeType());
        Assert.assertEquals((long)image.getSize(), (long)attachment.getSize());
        byte[] expectedContent = IOUtils.toByteArray((InputStream)this.documentHandlers.get(image).getContent(image));
        byte[] actualContent = IOUtils.toByteArray((InputStream)attachment.getContent());
        Assert.assertArrayEquals((byte[])expectedContent, (byte[])actualContent);
    }
}

