/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.internal.service;

import java.util.List;
import org.openvpms.component.business.domain.im.common.EntityIdentity;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Identity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.insurance.service.Insurers;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class InsurersImpl
implements Insurers {
    private final IArchetypeRuleService service;
    private final PlatformTransactionManager transactionManager;

    public InsurersImpl(IArchetypeRuleService service, PlatformTransactionManager transactionManager) {
        this.service = service;
        this.transactionManager = transactionManager;
    }

    public Party getInsurer(String archetype, String insurerId) {
        if (!TypeHelper.matches((String)archetype, (String)"entityIdentity.insurer*")) {
            throw new IllegalStateException("Invalid insurer identity archetype: " + archetype);
        }
        ArchetypeQuery query = new ArchetypeQuery("party.supplierInsurer", false);
        query.add((IConstraint)Constraints.join((String)"insurerId", (BaseArchetypeConstraint)Constraints.shortName((String)archetype, (boolean)false)).add((IConstraint)Constraints.eq((String)"identity", (Object)insurerId)));
        query.add((IConstraint)Constraints.sort((String)"id"));
        query.setMaxResults(1);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator((IArchetypeService)this.service, (IArchetypeQuery)query);
        return iterator.hasNext() ? (Party)iterator.next() : null;
    }

    public List<Party> getInsurers(String archetype, boolean activeOnly) {
        if (!TypeHelper.matches((String)archetype, (String)"entityIdentity.insurer*")) {
            throw new IllegalStateException("Invalid insurer identity archetype: " + archetype);
        }
        ArchetypeQuery query = new ArchetypeQuery("party.supplierInsurer", activeOnly);
        query.add((IConstraint)Constraints.join((String)"insurerId", (BaseArchetypeConstraint)Constraints.shortName((String)archetype, (boolean)false)));
        query.setMaxResults(-1);
        IPage page = this.service.get((IArchetypeQuery)query);
        return page.getResults();
    }

    public Party createInsurer(String archetype, String insurerId, String name, String description, Entity insuranceService) {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        return (Party)template.execute(transactionStatus -> {
            Party existing = this.getInsurer(archetype, insurerId);
            if (existing != null) {
                throw new IllegalStateException("An insurer already exists with insurerId=" + insurerId);
            }
            Party insurer = (Party)this.service.create("party.supplierInsurer", Party.class);
            EntityIdentity identity = (EntityIdentity)this.service.create(archetype, EntityIdentity.class);
            identity.setIdentity(insurerId);
            insurer.setName(name);
            insurer.setDescription(description);
            insurer.addIdentity((org.openvpms.component.model.entity.EntityIdentity)identity);
            IMObjectBean bean = this.service.getBean((IMObject)insurer);
            bean.addTarget("service", (IMObject)insuranceService);
            bean.save();
            return insurer;
        });
    }

    public Identity getIdentifier(Party insurer) {
        IMObjectBean bean = this.service.getBean((IMObject)insurer);
        return (Identity)bean.getObject("insurerId", EntityIdentity.class);
    }

    public String getInsurerId(Party insurer) {
        Identity identity = this.getIdentifier(insurer);
        return identity != null ? identity.getIdentity() : null;
    }
}

