/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.internal.claim;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.IterableUtils;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.cache.IMObjectCache;
import org.openvpms.insurance.claim.Condition;
import org.openvpms.insurance.claim.Invoice;
import org.openvpms.insurance.claim.Item;
import org.openvpms.insurance.claim.Note;
import org.openvpms.insurance.internal.claim.ClaimImpl;
import org.openvpms.insurance.internal.claim.InvoiceImpl;
import org.openvpms.insurance.internal.claim.ItemImpl;
import org.openvpms.insurance.internal.claim.NotesQuery;

public class ConditionImpl
implements Condition {
    private final IMObjectBean condition;
    private final Act act;
    private final Party patient;
    private final ArchetypeService service;
    private final ClaimImpl claim;
    private List<InvoiceImpl> invoices;
    private List<Note> notes;

    public ConditionImpl(Act act, Party patient, ClaimImpl claim, ArchetypeService service) {
        this.condition = service.getBean((IMObject)act);
        this.patient = patient;
        this.act = act;
        this.claim = claim;
        this.service = service;
    }

    public long getId() {
        return this.act.getId();
    }

    public OffsetDateTime getTreatedFrom() {
        return DateRules.toOffsetDateTime((Date)this.act.getActivityStartTime());
    }

    public OffsetDateTime getTreatedTo() {
        return DateRules.toOffsetDateTime((Date)this.act.getActivityEndTime());
    }

    public Lookup getDiagnosis() {
        return this.condition.getLookup("reason");
    }

    public String getDescription() {
        return this.condition.getObject().getDescription();
    }

    public Condition.Status getStatus() {
        return Condition.Status.valueOf((String)this.act.getStatus());
    }

    public String getEuthanasiaReason() {
        return this.condition.getString("euthanasiaReason");
    }

    public List<Note> getConsultationNotes() {
        if (this.notes == null) {
            Date from = DateRules.getDate((Date)this.act.getActivityStartTime());
            Date to = DateRules.getNextDate((Date)this.act.getActivityEndTime());
            NotesQuery query = new NotesQuery(this.service);
            this.notes = IterableUtils.toList(query.query(this.patient, from, true, to, true, 100));
        }
        return this.notes;
    }

    public BigDecimal getDiscount() {
        BigDecimal discount = BigDecimal.ZERO;
        for (Invoice invoice : this.getInvoices()) {
            discount = discount.add(invoice.getDiscount());
        }
        return discount;
    }

    public BigDecimal getDiscountTax() {
        BigDecimal tax = BigDecimal.ZERO;
        for (Invoice invoice : this.getInvoices()) {
            tax = tax.add(invoice.getDiscountTax());
        }
        return tax;
    }

    public BigDecimal getTotal() {
        BigDecimal total = BigDecimal.ZERO;
        for (Invoice invoice : this.getInvoices()) {
            total = total.add(invoice.getTotal());
        }
        return total;
    }

    public BigDecimal getTotalTax() {
        BigDecimal tax = BigDecimal.ZERO;
        for (Invoice invoice : this.getInvoices()) {
            tax = tax.add(invoice.getTotalTax());
        }
        return tax;
    }

    public BigDecimal getCurrentPaid() {
        return this.claim.getAllocation(this);
    }

    public BigDecimal getCurrentBalance() {
        return this.getTotal().subtract(this.getCurrentPaid());
    }

    public List<Invoice> getInvoices() {
        List<InvoiceImpl> invoices = this.getInvoiceImpls();
        return new ArrayList<Invoice>(invoices);
    }

    public List<InvoiceImpl> getInvoiceImpls() {
        if (this.invoices == null) {
            this.invoices = this.collectInvoices();
        }
        return this.invoices;
    }

    private List<InvoiceImpl> collectInvoices() {
        ArrayList<InvoiceImpl> result = new ArrayList<InvoiceImpl>();
        HashMap<FinancialAct, List> invoices = new HashMap<FinancialAct, List>();
        IMObjectCache cache = this.claim.getCache();
        for (Reference reference : this.condition.getTargetRefs("items")) {
            FinancialAct item = (FinancialAct)cache.get(reference);
            if (item == null) {
                throw new IllegalStateException("Invoice item=" + reference + " not found");
            }
            IMObjectBean bean = this.service.getBean((IMObject)item);
            Reference ref = bean.getSourceRef("invoice");
            FinancialAct invoice = (FinancialAct)cache.get(ref);
            if (invoice == null) {
                throw new IllegalStateException("Invoice item=" + item.getObjectReference() + " has no invoice");
            }
            List items = invoices.computeIfAbsent(invoice, k -> new ArrayList());
            items.add(item);
        }
        for (Map.Entry entry : invoices.entrySet()) {
            FinancialAct invoice = (FinancialAct)entry.getKey();
            ArrayList<Item> items = new ArrayList<Item>();
            for (FinancialAct item : (List)entry.getValue()) {
                items.add(new ItemImpl((Act)item, this.service));
            }
            items.sort(Comparator.comparing(Item::getDate));
            result.add(new InvoiceImpl(invoice, items));
        }
        result.sort(Comparator.comparing(Invoice::getDate));
        return result;
    }
}

