/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.internal.claim;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.query.TypedQuery;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Path;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.criteria.TypedQueryIterator;
import org.openvpms.insurance.claim.Note;
import org.openvpms.insurance.internal.claim.NoteImpl;

class NotesQuery {
    private final ArchetypeService service;

    public NotesQuery(ArchetypeService service) {
        this.service = service;
    }

    public Iterable<Note> query(Party patient, Date from, boolean inclusiveFrom, Date to, boolean inclusiveTo, int pageSize) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Act.class);
        Root note = query.from(Act.class, new String[]{"act.patientClinicalNote"});
        query.select((Selection)note);
        Join withEvent = note.join("event").join("source");
        Join withPatient = withEvent.join("patient").join("entity");
        withPatient.on((Expression)builder.equal((Expression)withPatient.reference(), (Object)patient.getObjectReference()));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Path startTime = withEvent.get("startTime");
        Path endTime = withEvent.get("endTime");
        if (from != null) {
            Predicate lower = inclusiveFrom ? builder.greaterThanOrEqualTo((Expression)startTime, (Comparable)from) : builder.greaterThan((Expression)startTime, (Comparable)from);
            predicates.add(lower);
        }
        if (to != null) {
            Predicate upper = inclusiveTo ? builder.lessThanOrEqualTo((Expression)endTime, (Comparable)to) : builder.lessThan((Expression)endTime, (Comparable)to);
            predicates.add(builder.or((Expression)builder.isNull((Expression)endTime), (Expression)upper));
        }
        query.where(predicates);
        query.orderBy(new Order[]{builder.asc((Expression)startTime), builder.asc((Expression)withEvent.get("id")), builder.asc((Expression)note.get("startTime")), builder.asc((Expression)note.get("id"))});
        return () -> {
            TypedQuery typedQuery = this.service.createQuery(query);
            return new NoteIterator((Iterator<Act>)new TypedQueryIterator(typedQuery, pageSize), this.service);
        };
    }

    private static class NoteIterator
    implements Iterator<Note> {
        private final Iterator<Act> iterator;
        private final ArchetypeService service;

        public NoteIterator(Iterator<Act> iterator, ArchetypeService service) {
            this.iterator = iterator;
            this.service = service;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Note next() {
            Act act = this.iterator.next();
            return new NoteImpl(act, this.service);
        }
    }
}

