/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.internal.claim;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.IMObjectBeanFactory;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.insurance.claim.Deposit;
import org.openvpms.insurance.claim.GapClaim;
import org.openvpms.insurance.claim.GapClaimUpdater;
import org.openvpms.insurance.internal.claim.ClaimUpdaterImpl;
import org.openvpms.insurance.internal.claim.DepositImpl;
import org.openvpms.insurance.internal.claim.GapClaimImpl;

class GapClaimUpdaterImpl
extends ClaimUpdaterImpl
implements GapClaimUpdater {
    private final List<FinancialAct> newDeposits = new ArrayList<FinancialAct>();
    private BigDecimal benefitAmount;
    private String benefitNotes;
    private BigDecimal vetBenefitAmount;
    private Map<String, Deposit> allDeposits;

    public GapClaimUpdaterImpl(GapClaimImpl claim, IMObjectBean bean, ArchetypeService service, InsuranceRules rules) {
        super(claim, bean, service, rules);
    }

    public GapClaimUpdater benefit(BigDecimal amount, String notes) {
        GapClaim.GapStatus status = this.getClaim().getGapStatus();
        if (status != GapClaim.GapStatus.PENDING) {
            throw new IllegalStateException("Cannot set the benefit amount for gap claims with status=" + status);
        }
        if (amount == null) {
            throw new IllegalArgumentException("Argument 'amount' is required");
        }
        if (amount.compareTo(MathRules.round((BigDecimal)amount, (int)2)) != 0) {
            throw new IllegalArgumentException("Argument 'amount' must be rounded to 2 decimal places");
        }
        this.benefitAmount = amount;
        this.benefitNotes = notes;
        return this;
    }

    public GapClaimUpdater vetBenefitAmount(BigDecimal amount) {
        this.vetBenefitAmount = amount;
        return this;
    }

    public boolean hasDeposit(String id) {
        return this.getDeposits().get(id) != null;
    }

    public GapClaimUpdater deposit(String id, String archetype, OffsetDateTime date, BigDecimal amount) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 'id' is required");
        }
        if (!TypeHelper.isA((String)archetype, (String[])new String[]{"actIdentity.insuranceDeposit*"})) {
            throw new IllegalArgumentException("Argument 'archetype' must have a actIdentity.insuranceDeposit* prefix");
        }
        if (date == null) {
            throw new IllegalArgumentException("Argument 'date' is required");
        }
        if (amount == null) {
            throw new IllegalArgumentException("Argument 'amount' is required");
        }
        if (amount.compareTo(MathRules.round((BigDecimal)amount, (int)2)) != 0) {
            throw new IllegalArgumentException("Argument 'amount' must be rounded to 2 decimal places");
        }
        if (this.hasDeposit(id)) {
            throw new IllegalArgumentException("Duplicate deposit with identifier " + id);
        }
        ArchetypeService service = this.getService();
        FinancialAct act = (FinancialAct)service.create("act.patientInsuranceClaimDeposit", FinancialAct.class);
        ActIdentity identity = (ActIdentity)service.create(archetype, ActIdentity.class);
        identity.setIdentity(id);
        act.setActivityStartTime(DateRules.toDate((OffsetDateTime)date));
        act.setTotal(amount);
        act.addIdentity(identity);
        this.newDeposits.add(act);
        this.allDeposits.put(id, new DepositImpl((Act)act, (IMObjectBeanFactory)service));
        return this;
    }

    public GapClaim update() {
        return (GapClaim)super.update();
    }

    @Override
    protected GapClaimImpl getClaim() {
        return (GapClaimImpl)super.getClaim();
    }

    @Override
    protected boolean doUpdate(IMObjectBean bean, List<IMObject> toSave) {
        boolean updated = super.doUpdate(bean, toSave);
        updated |= this.updateBenefit(bean);
        updated |= this.updateVetBenefit(bean);
        return updated |= this.updateDeposits(bean, toSave);
    }

    private boolean updateBenefit(IMObjectBean bean) {
        boolean updated = false;
        if (!(this.benefitAmount == null || Objects.equals(this.benefitAmount, bean.getBigDecimal("benefitAmount")) && Objects.equals(this.benefitNotes, bean.getString("benefitNotes")) && Objects.equals(GapClaim.GapStatus.RECEIVED.toString(), bean.getString("status2")))) {
            bean.setValue("benefitAmount", (Object)this.benefitAmount);
            bean.setValue("benefitNotes", (Object)this.benefitNotes);
            bean.setValue("status2", (Object)GapClaim.GapStatus.RECEIVED.toString());
            updated = true;
        }
        return updated;
    }

    private boolean updateVetBenefit(IMObjectBean bean) {
        boolean updated = false;
        if (this.vetBenefitAmount != null && !Objects.equals(this.vetBenefitAmount, bean.getBigDecimal("vetBenefitAmount"))) {
            bean.setValue("vetBenefitAmount", (Object)this.vetBenefitAmount);
            updated = true;
        }
        return updated;
    }

    private boolean updateDeposits(IMObjectBean bean, List<IMObject> toSave) {
        boolean updated = false;
        if (!this.newDeposits.isEmpty()) {
            BigDecimal total = BigDecimal.ZERO;
            for (FinancialAct act : this.newDeposits) {
                bean.addTarget("deposits", (IMObject)act, "claim");
                toSave.add((IMObject)act);
            }
            for (Deposit deposit : this.allDeposits.values()) {
                total = total.add(deposit.getAmount());
            }
            updated = true;
            this.getClaim().updateDeposits(new ArrayList<Deposit>(this.allDeposits.values()));
        }
        return updated;
    }

    private Map<String, Deposit> getDeposits() {
        if (this.allDeposits == null) {
            this.allDeposits = new HashMap<String, Deposit>();
            for (Deposit deposit : this.getClaim().getDeposits()) {
                this.allDeposits.put(deposit.getDepositId(), deposit);
            }
        }
        return this.allDeposits;
    }
}

