/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.internal.claim;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.credit.CreditActAllocator;
import org.openvpms.archetype.rules.finance.credit.CreditAllocation;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.IMObjectBeanFactory;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.insurance.claim.Claim;
import org.openvpms.insurance.claim.Deposit;
import org.openvpms.insurance.claim.GapClaim;
import org.openvpms.insurance.claim.GapClaimUpdater;
import org.openvpms.insurance.internal.claim.ClaimImpl;
import org.openvpms.insurance.internal.claim.DepositImpl;
import org.openvpms.insurance.internal.claim.GapClaimUpdaterImpl;
import org.openvpms.insurance.internal.i18n.InsuranceMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;

public class GapClaimImpl
extends ClaimImpl
implements GapClaim {
    private final CustomerAccountRules accountRules;
    private List<Deposit> deposits;
    static final String GAP_CLAIM = "gapClaim";
    static final String GAP_STATUS = "status2";
    static final String PAID = "paid";
    static final String BENEFIT_AMOUNT = "benefitAmount";
    static final String VET_BENEFIT_AMOUNT = "vetBenefitAmount";
    static final String BENEFIT_NOTES = "benefitNotes";
    static final String DEPOSITS = "deposits";
    private static final Logger log = LoggerFactory.getLogger(GapClaimImpl.class);
    public static final String GAP_BENEFIT_PAYMENT = "GAP_BENEFIT_PAYMENT";

    public GapClaimImpl(FinancialAct claim, IArchetypeService service, InsuranceRules insuranceRules, CustomerRules customerRules, CustomerAccountRules accountRules, PatientRules patientRules, MedicalRecordRules recordRules, DocumentHandlers handlers, PlatformTransactionManager transactionManager, DomainService domainService) {
        this(service.getBean((IMObject)claim), service, insuranceRules, customerRules, accountRules, patientRules, recordRules, handlers, transactionManager, domainService);
    }

    public GapClaimImpl(IMObjectBean claim, IArchetypeService service, InsuranceRules insuranceRules, CustomerRules customerRules, CustomerAccountRules accountRules, PatientRules patientRules, MedicalRecordRules recordRules, DocumentHandlers handlers, PlatformTransactionManager transactionManager, DomainService domainService) {
        super(claim, service, insuranceRules, customerRules, patientRules, recordRules, handlers, transactionManager, domainService);
        this.accountRules = accountRules;
    }

    public BigDecimal getBenefitAmount() {
        return this.getClaim().getBigDecimal(BENEFIT_AMOUNT, BigDecimal.ZERO);
    }

    public BigDecimal getVetBenefitAmount() {
        return this.getClaim().getBigDecimal(VET_BENEFIT_AMOUNT, BigDecimal.ZERO);
    }

    public void setVetBenefitAmount(BigDecimal amount) {
        this.state().vetBenefitAmount(amount).update();
    }

    public BigDecimal getPaid() {
        return this.getClaim().getBigDecimal(PAID, BigDecimal.ZERO);
    }

    public void fullyPaid() {
        GapClaim.GapStatus status = this.getGapStatus();
        if (status == GapClaim.GapStatus.PAID || status == GapClaim.GapStatus.NOTIFIED) {
            throw new IllegalStateException("Cannot update paid status for gap claim with status=" + status);
        }
        IMObjectBean claim = this.getClaim();
        claim.setValue(GAP_STATUS, (Object)GapClaim.GapStatus.PAID);
        claim.setValue(PAID, (Object)this.getTotal());
        claim.save();
        this.resetAllocations();
    }

    public FinancialAct gapPaid(Entity till, Party location) {
        ArrayList adjustment = null;
        GapClaim.GapStatus status = this.getGapStatus();
        if (status != GapClaim.GapStatus.RECEIVED) {
            throw new IllegalStateException("Cannot update paid status for gap claim with status=" + status);
        }
        Party customer = this.getCustomer();
        BigDecimal benefitAmount = this.getBenefitAmount();
        BigDecimal gapAmount = this.getGapAmount();
        IMObjectBean claim = this.getClaim();
        claim.setValue(GAP_STATUS, (Object)GapClaim.GapStatus.PAID);
        claim.setValue(PAID, (Object)gapAmount);
        if (!MathRules.isZero((BigDecimal)benefitAmount)) {
            if (till == null) {
                throw new IllegalArgumentException("Argument 'till' is required for a non-zero benefit amount");
            }
            String notes = this.getBenefitPaymentNotes();
            if (notes != null) {
                int maxLength = claim.getMaxLength("notes");
                if (notes.length() > maxLength) {
                    notes = StringUtils.abbreviate((String)notes, (int)maxLength);
                }
            }
            String paymentType = this.getPaymentType();
            adjustment = new ArrayList(this.accountRules.createPaymentOther(customer, benefitAmount, till, location, paymentType, notes));
            IArchetypeService service = this.getService();
            CreditActAllocator allocator = new CreditActAllocator(service, this.getInsuranceRules());
            List<FinancialAct> invoices = this.getInvoices();
            LinkedHashSet<Object> toSave = new LinkedHashSet<Object>();
            toSave.add(claim.getObject(FinancialAct.class));
            CreditAllocation allocation = allocator.allocate((FinancialAct)adjustment.get(0), invoices, false);
            toSave.addAll(adjustment);
            if (allocation.isModified()) {
                toSave.addAll(allocation.getModified());
            }
            service.save(toSave);
        } else {
            claim.save();
        }
        this.resetAllocations();
        return adjustment != null ? (FinancialAct)adjustment.get(0) : null;
    }

    protected String getPaymentType() {
        Party insurer = this.getInsurer();
        IMObjectBean bean = this.getService().getBean((IMObject)insurer);
        Lookup paymentType = (Lookup)bean.getObject("paymentType", Lookup.class);
        return paymentType != null ? paymentType.getCode() : GAP_BENEFIT_PAYMENT;
    }

    public BigDecimal getGapAmount() {
        BigDecimal total = this.getTotal();
        BigDecimal benefit = this.getBenefitAmount();
        return this.getInsuranceRules().getGapAmount(total, benefit);
    }

    public String getBenefitNotes() {
        return this.getClaim().getString(BENEFIT_NOTES);
    }

    public GapClaim.GapStatus getGapStatus() {
        GapClaim.GapStatus result = null;
        IMObjectBean claim = this.getClaim();
        if (claim.getBoolean(GAP_CLAIM)) {
            String status = claim.getString(GAP_STATUS);
            result = status != null ? GapClaim.GapStatus.valueOf((String)status) : GapClaim.GapStatus.PENDING;
        }
        return result;
    }

    public void setBenefit(BigDecimal amount, String notes) {
        this.state().benefit(amount, notes).update();
    }

    public void paymentNotified() {
        GapClaim.GapStatus status = this.getGapStatus();
        if (status != GapClaim.GapStatus.PAID) {
            throw new IllegalStateException("Cannot update gap status to NOTIFIED when gap status=" + status);
        }
        this.withTransaction(() -> {
            IMObjectBean claim = this.getClaim();
            claim.setValue(GAP_STATUS, (Object)GapClaim.GapStatus.NOTIFIED.toString());
            claim.save();
            if (this.getStatus() == Claim.Status.PRE_SETTLED) {
                this.state().status(Claim.Status.SETTLED).update();
            }
        });
    }

    public List<Deposit> getDeposits() {
        if (this.deposits == null) {
            this.deposits = new ArrayList<Deposit>();
            for (Act act : this.getClaim().getTargets(DEPOSITS, Act.class)) {
                this.deposits.add(new DepositImpl(act, (IMObjectBeanFactory)this.getService()));
            }
        }
        return this.deposits;
    }

    public GapClaimUpdater state() {
        return new GapClaimUpdaterImpl(this, this.getClaim(), (ArchetypeService)this.getService(), this.getInsuranceRules());
    }

    @Override
    public GapClaimImpl reload() {
        return (GapClaimImpl)super.reload();
    }

    @Override
    protected void finaliseClaim() {
        super.finaliseClaim();
        IMObjectBean claim = this.getClaim();
        claim.setValue(GAP_STATUS, (Object)GapClaim.GapStatus.PENDING.toString());
    }

    @Override
    protected ClaimImpl newInstance(Act claim, IArchetypeService service, InsuranceRules insuranceRules, CustomerRules customerRules, PatientRules patientRules, MedicalRecordRules recordRules, DocumentHandlers handlers, PlatformTransactionManager transactionManager, DomainService domainService) {
        return new GapClaimImpl(service.getBean((IMObject)claim), service, insuranceRules, customerRules, this.accountRules, patientRules, recordRules, handlers, transactionManager, domainService);
    }

    protected void updateDeposits(List<Deposit> deposits) {
        this.deposits = deposits;
    }

    private String getBenefitPaymentNotes() {
        try {
            return InsuranceMessages.benefitPaymentNotes(this.getInsurerId(), this.getPatient().getName(), this.getInsurer().getName()).getMessage();
        }
        catch (Throwable exception) {
            log.error("Failed to generate benefit payment notes", exception);
            return null;
        }
    }
}

