/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.internal.claim;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.IterableUtils;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.rules.party.PartyRules;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.domain.im.act.ActIdentity;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.domain.im.security.User;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.cache.IMObjectCache;
import org.openvpms.component.system.common.cache.MapIMObjectCache;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.practice.LocationImpl;
import org.openvpms.domain.party.Email;
import org.openvpms.domain.party.Phone;
import org.openvpms.domain.patient.Patient;
import org.openvpms.domain.practice.Location;
import org.openvpms.insurance.claim.Attachment;
import org.openvpms.insurance.claim.Claim;
import org.openvpms.insurance.claim.ClaimHandler;
import org.openvpms.insurance.claim.ClaimUpdater;
import org.openvpms.insurance.claim.Condition;
import org.openvpms.insurance.claim.History;
import org.openvpms.insurance.claim.Invoice;
import org.openvpms.insurance.claim.Note;
import org.openvpms.insurance.exception.InsuranceException;
import org.openvpms.insurance.internal.claim.Allocations;
import org.openvpms.insurance.internal.claim.AttachmentImpl;
import org.openvpms.insurance.internal.claim.ClaimUpdaterImpl;
import org.openvpms.insurance.internal.claim.ConditionImpl;
import org.openvpms.insurance.internal.claim.HistoryImpl;
import org.openvpms.insurance.internal.i18n.InsuranceMessages;
import org.openvpms.insurance.internal.policy.PolicyImpl;
import org.openvpms.insurance.policy.Policy;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class ClaimImpl
implements Claim {
    private final IMObjectBean claim;
    private final Act act;
    private final IArchetypeService service;
    private final InsuranceRules insuranceRules;
    private final CustomerRules customerRules;
    private final PatientRules patientRules;
    private final MedicalRecordRules recordRules;
    private final DocumentHandlers handlers;
    private final PlatformTransactionManager transactionManager;
    private final DomainService domainService;
    private final Allocations allocations;
    private final IMObjectCache cache;
    private PolicyImpl policy;
    private List<Condition> conditions;
    private List<Note> history;
    private List<Attachment> attachments;
    private ClaimHandler handler;

    public ClaimImpl(Act claim, IArchetypeService service, InsuranceRules insuranceRules, CustomerRules customerRules, PatientRules patientRules, MedicalRecordRules recordRules, DocumentHandlers handlers, PlatformTransactionManager transactionManager, DomainService domainService) {
        this(service.getBean((IMObject)claim), claim, service, insuranceRules, customerRules, patientRules, recordRules, handlers, transactionManager, domainService);
    }

    public ClaimImpl(IMObjectBean claim, IArchetypeService service, InsuranceRules insuranceRules, CustomerRules customerRules, PatientRules patientRules, MedicalRecordRules recordRules, DocumentHandlers handlers, PlatformTransactionManager transactionManager, DomainService domainService) {
        this(claim, (Act)claim.getObject(Act.class), service, insuranceRules, customerRules, patientRules, recordRules, handlers, transactionManager, domainService);
    }

    private ClaimImpl(IMObjectBean claim, Act act, IArchetypeService service, InsuranceRules insuranceRules, CustomerRules customerRules, PatientRules patientRules, MedicalRecordRules recordRules, DocumentHandlers handlers, PlatformTransactionManager transactionManager, DomainService domainService) {
        this.claim = claim;
        this.act = act;
        this.service = service;
        this.insuranceRules = insuranceRules;
        this.customerRules = customerRules;
        this.patientRules = patientRules;
        this.recordRules = recordRules;
        this.handlers = handlers;
        this.transactionManager = transactionManager;
        this.domainService = domainService;
        this.allocations = new Allocations(this, (ArchetypeService)service);
        this.cache = new MapIMObjectCache((ArchetypeService)service);
    }

    public long getId() {
        return this.claim.getObject().getId();
    }

    public String getInsurerId() {
        ActIdentity identity = this.getIdentity();
        return identity != null ? identity.getIdentity() : null;
    }

    public void setInsurerId(String archetype, String id) {
        this.state().insurerId(archetype, id).update();
    }

    public OffsetDateTime getCreated() {
        return DateRules.toOffsetDateTime((Date)this.claim.getDate("startTime"));
    }

    public OffsetDateTime getCompleted() {
        return DateRules.toOffsetDateTime((Date)this.claim.getDate("endTime"));
    }

    public BigDecimal getDiscount() {
        BigDecimal result = BigDecimal.ZERO;
        for (Condition condition : this.getConditions()) {
            result = result.add(condition.getDiscount());
        }
        return result;
    }

    public BigDecimal getDiscountTax() {
        BigDecimal result = BigDecimal.ZERO;
        for (Condition condition : this.getConditions()) {
            result = result.add(condition.getDiscountTax());
        }
        return result;
    }

    public BigDecimal getTotal() {
        return this.claim.getBigDecimal("amount", BigDecimal.ZERO);
    }

    public BigDecimal getTotalTax() {
        return this.claim.getBigDecimal("tax", BigDecimal.ZERO);
    }

    public BigDecimal getCurrentPaid() {
        return this.allocations.getConditionTotal();
    }

    public BigDecimal getCurrentBalance() {
        return this.getTotal().subtract(this.getCurrentPaid());
    }

    public BigDecimal getAllocation(ConditionImpl condition) {
        return this.allocations.getAllocation(condition);
    }

    public Patient getAnimal() {
        return this.getPolicy().getAnimal();
    }

    public Policy getPolicy() {
        if (this.policy == null) {
            this.policy = new PolicyImpl((Act)this.claim.getTarget("policy", Act.class), (ArchetypeService)this.service, this.customerRules, this.patientRules, this.domainService);
        }
        return this.policy;
    }

    public Policy setPolicy(Party insurer, String policyNumber) {
        this.state().policy(insurer, policyNumber).update();
        return this.getPolicy();
    }

    public Party getCustomer() {
        return ((PolicyImpl)this.getPolicy()).getCustomer();
    }

    public Party getPatient() {
        return ((PolicyImpl)this.getPolicy()).getPatient();
    }

    public Party getInsurer() {
        return this.getPolicy().getInsurer();
    }

    public Claim.Status getStatus() {
        return Claim.Status.valueOf((String)this.act.getStatus());
    }

    public void setStatus(Claim.Status status) {
        this.state().status(status).update();
    }

    public void setStatus(Claim.Status status, String message) {
        this.state().status(status, message).update();
    }

    public List<Condition> getConditions() {
        if (this.conditions == null) {
            this.conditions = this.collectConditions();
        }
        return this.conditions;
    }

    public List<Note> getClinicalHistory() {
        if (this.history == null) {
            this.history = this.collectHistory();
        }
        return this.history;
    }

    public History getHistory() {
        List<Condition> conditions = this.getConditions();
        OffsetDateTime minTreatmentDate = conditions.stream().map(Condition::getTreatedFrom).min(Comparator.naturalOrder()).orElse(this.getCreated());
        OffsetDateTime maxTreatmentDate = conditions.stream().map(Condition::getTreatedTo).max(Comparator.naturalOrder()).orElse(this.getCreated());
        return new HistoryImpl(this.getPatient(), this.getInsurer(), this.act, DateRules.toDate((OffsetDateTime)minTreatmentDate), DateRules.toDate((OffsetDateTime)maxTreatmentDate), this.insuranceRules, this.recordRules, (ArchetypeService)this.service);
    }

    public List<Attachment> getAttachments() {
        if (this.attachments == null) {
            this.attachments = this.collectAttachments();
        }
        return this.attachments;
    }

    public User getClinician() {
        return (User)this.claim.getTarget("clinician", User.class);
    }

    public ClaimHandler getClaimHandler() {
        if (this.handler == null) {
            final User user = (User)this.claim.getTarget("user", User.class);
            if (user == null) {
                throw new IllegalStateException("Claim has no user");
            }
            final Location location = this.getLocation();
            this.handler = new ClaimHandler(){

                public String getName() {
                    return user.getName();
                }

                public Phone getPhone() {
                    return location != null ? location.getPhone() : null;
                }

                public Email getEmail() {
                    return location != null ? location.getEmail() : null;
                }
            };
        }
        return this.handler;
    }

    public Location getLocation() {
        return new LocationImpl(this.getLocationParty(), (PartyRules)this.customerRules, this.domainService);
    }

    public Party getLocationParty() {
        Party location = (Party)this.claim.getTarget("location", Party.class);
        if (location == null) {
            throw new IllegalStateException("Claim has no location");
        }
        return location;
    }

    public void setMessage(String message) {
        this.state().message(message).update();
    }

    public String getMessage() {
        return this.claim.getString("message");
    }

    public boolean canCancel() {
        Claim.Status status = this.getStatus();
        return status == Claim.Status.PENDING || status == Claim.Status.POSTED || status == Claim.Status.SUBMITTED || Claim.Status.ACCEPTED == status;
    }

    public void finalise() {
        Claim.Status status = this.getStatus();
        if (status != Claim.Status.PENDING) {
            Lookup lookup = this.claim.getLookup("status");
            String displayName = lookup != null ? lookup.getName() : status.name();
            throw new InsuranceException(InsuranceMessages.cannotFinaliseClaimWithStatus(displayName));
        }
        for (Attachment attachment : this.getAttachments()) {
            if (attachment.getStatus() == Attachment.Status.ERROR) {
                throw new InsuranceException(InsuranceMessages.cannotFinaliseClaimAttachmentError(attachment.getFileName()));
            }
            if (attachment.hasContent()) continue;
            throw new InsuranceException(InsuranceMessages.cannotFinaliseClaimNoAttachment(attachment.getFileName()));
        }
        try {
            this.withTransaction(this::finaliseClaim);
        }
        catch (InsuranceException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new InsuranceException(InsuranceMessages.failedToFinaliseClaim(exception.getMessage()), (Throwable)exception);
        }
    }

    protected void withTransaction(final Runnable operation) {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                operation.run();
            }
        });
    }

    public ClaimUpdater state() {
        return new ClaimUpdaterImpl(this, this.claim, (ArchetypeService)this.service, this.insuranceRules);
    }

    public ClaimImpl reload() {
        Act object = (Act)this.service.get(this.act.getObjectReference(), Act.class);
        if (object == null) {
            throw new IllegalStateException("Cannot reload claim=" + this.act.getObjectReference() + ". It has been deleted");
        }
        return this.newInstance(object, this.service, this.insuranceRules, this.customerRules, this.patientRules, this.recordRules, this.handlers, this.transactionManager, this.domainService);
    }

    public List<FinancialAct> getInvoices() {
        HashMap invoices = new HashMap();
        MapIMObjectCache cache = new MapIMObjectCache(invoices, (ArchetypeService)this.service);
        for (Condition condition : this.getConditions()) {
            for (Invoice invoice : condition.getInvoices()) {
                IMObjectReference reference = new IMObjectReference("act.customerAccountChargesInvoice", invoice.getId());
                if (cache.get((Reference)reference) != null) continue;
                throw new IllegalStateException("Failed to retrieve invoice=" + reference + " associated with claim=" + this.getId());
            }
        }
        return new ArrayList<FinancialAct>(invoices.values());
    }

    public BigDecimal getInvoiceAllocation() {
        return this.allocations.getInvoiceTotal();
    }

    protected PolicyImpl getPolicyImpl() {
        this.getPolicy();
        return this.policy;
    }

    protected void updatePolicy(Act policy) {
        this.policy = new PolicyImpl(policy, (ArchetypeService)this.service, this.customerRules, this.patientRules, this.domainService);
    }

    protected IMObjectCache getCache() {
        return this.cache;
    }

    protected void finaliseClaim() {
        this.setStatus(Claim.Status.POSTED);
        for (Attachment attachment : this.getAttachments()) {
            if (attachment.getStatus() != Attachment.Status.PENDING) continue;
            attachment.setStatus(Attachment.Status.POSTED);
        }
    }

    protected ClaimImpl newInstance(Act claim, IArchetypeService service, InsuranceRules insuranceRules, CustomerRules customerRules, PatientRules patientRules, MedicalRecordRules recordRules, DocumentHandlers handlers, PlatformTransactionManager transactionManager, DomainService domainService) {
        return new ClaimImpl(claim, service, insuranceRules, customerRules, patientRules, recordRules, handlers, transactionManager, domainService);
    }

    protected IMObjectBean getClaim() {
        return this.claim;
    }

    protected List<Condition> collectConditions() {
        ArrayList<Condition> result = new ArrayList<Condition>();
        Party patient = this.getPatient();
        for (Act act : this.claim.getTargets("items", Act.class)) {
            result.add(new ConditionImpl(act, patient, this, (ArchetypeService)this.service));
        }
        return result;
    }

    protected List<Note> collectHistory() {
        Iterable notes = this.getHistory().getNotes();
        return IterableUtils.toList((Iterable)notes);
    }

    protected List<Attachment> collectAttachments() {
        ArrayList<Attachment> result = new ArrayList<Attachment>();
        for (DocumentAct act : this.claim.getTargets("attachments", DocumentAct.class)) {
            result.add(new AttachmentImpl(act, (ArchetypeService)this.service, this.handlers));
        }
        return result;
    }

    protected ActIdentity getIdentity() {
        return (ActIdentity)this.claim.getObject("insurerId", ActIdentity.class);
    }

    protected IArchetypeService getService() {
        return this.service;
    }

    protected InsuranceRules getInsuranceRules() {
        return this.insuranceRules;
    }

    protected void resetAllocations() {
        this.cache.clear();
        this.allocations.clear();
    }
}

