/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.internal.policy;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.insurance.InsuranceTestHelper;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.patient.Patient;
import org.openvpms.insurance.internal.policy.PolicyImpl;
import org.springframework.beans.factory.annotation.Autowired;

public class PolicyImplTestCase
extends ArchetypeServiceTest {
    @Autowired
    private PatientRules patientRules;
    @Autowired
    private DomainService domainService;

    @Test
    public void testPolicy() {
        Contact address = TestHelper.createLocationContact((String)"12 Broadwater Avenue", (String)"CAPE_WOOLAMAI", (String)"VIC", (String)"3925");
        Contact home = TestHelper.createPhoneContact((String)"03", (String)"9123456", (boolean)false, (boolean)false, (String)"HOME");
        Contact work = TestHelper.createPhoneContact((String)"03", (String)"9123456", (boolean)false, (boolean)false, (String)"WORK");
        Contact mobile = TestHelper.createPhoneContact(null, (String)"04987654321", (boolean)true, (boolean)true, (String)"MOBILE");
        Contact email = TestHelper.createEmailContact((String)"foo@test.com");
        Party customer = TestHelper.createCustomer((String)"MS", (String)"J", (String)"Bloggs", (Contact[])new Contact[]{address, home, work, mobile, email});
        Date dateOfBirth = DateRules.getDate((Date)DateRules.getToday(), (int)-1, (DateUnits)DateUnits.YEARS);
        Party patient = PatientTestHelper.createPatient((String)"Fido", (String)"CANINE", (String)"PUG", (String)"MALE", (Date)dateOfBirth, (String)"123454321", (String)"BLACK", (Party)customer);
        Party insurer = InsuranceTestHelper.createInsurer((String)TestHelper.randomName((String)"ZInsurer-"));
        Act act = InsuranceTestHelper.createPolicy((Party)customer, (Party)patient, (Party)insurer, (ActIdentity)TestHelper.createActIdentity((String)"actIdentity.insurancePolicy", (String)"123456"));
        CustomerRules customerRules = new CustomerRules(this.getArchetypeService(), this.getLookupService());
        PolicyImpl policy = new PolicyImpl(act, (ArchetypeService)((IArchetypeRuleService)this.getArchetypeService()), customerRules, this.patientRules, this.domainService);
        Assert.assertEquals((Object)"123456", (Object)policy.getPolicyNumber());
        Assert.assertEquals((Object)act.getActivityEndTime(), (Object)DateRules.toDate((OffsetDateTime)policy.getExpiryDate()));
        Customer policyHolder = policy.getPolicyHolder();
        Assert.assertNotNull((Object)policyHolder);
        Assert.assertEquals((Object)"Ms J Bloggs", (Object)policyHolder.getFullName());
        Assert.assertEquals((Object)address, (Object)policyHolder.getAddress());
        Assert.assertEquals((Object)work, (Object)policyHolder.getWorkPhone());
        Assert.assertEquals((Object)home, (Object)policyHolder.getHomePhone());
        Assert.assertEquals((Object)mobile, (Object)policyHolder.getMobilePhone());
        Assert.assertEquals((Object)email, (Object)policyHolder.getEmail());
        Patient animal = policy.getAnimal();
        Assert.assertNotNull((Object)animal);
        Assert.assertEquals((long)patient.getId(), (long)animal.getId());
        Assert.assertEquals((Object)"Fido", (Object)animal.getName());
        Assert.assertEquals((Object)dateOfBirth, (Object)DateRules.toDate((LocalDate)animal.getDateOfBirth()));
        Assert.assertEquals((Object)"Canine", (Object)animal.getSpeciesName());
        Assert.assertEquals((Object)"Pug", (Object)animal.getBreedName());
        Assert.assertEquals((Object)Patient.Sex.MALE, (Object)animal.getSex());
        Assert.assertEquals((Object)"123454321", (Object)animal.getMicrochip().getIdentity());
        Assert.assertEquals((Object)"Black", (Object)animal.getColourName());
        Assert.assertEquals((Object)insurer, (Object)policy.getInsurer());
    }
}

