/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.service;

public class PolicyValidationStatus {
    private final Status status;
    private final String policyNumber;
    private final String message;

    private PolicyValidationStatus(Status status) {
        this(status, null);
    }

    private PolicyValidationStatus(Status status, String policyNumber) {
        this(status, policyNumber, null);
    }

    private PolicyValidationStatus(Status status, String policyNumber, String message) {
        this.status = status;
        this.policyNumber = policyNumber;
        this.message = message;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getPolicyNumber() {
        return this.policyNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public static PolicyValidationStatus valid() {
        return new PolicyValidationStatus(Status.VALID);
    }

    public static PolicyValidationStatus invalid(String message) {
        return new PolicyValidationStatus(Status.INVALID, null, message);
    }

    public static PolicyValidationStatus notFound() {
        return new PolicyValidationStatus(Status.NOT_FOUND);
    }

    public static PolicyValidationStatus expired() {
        return new PolicyValidationStatus(Status.EXPIRED);
    }

    public static PolicyValidationStatus changePolicyNumber(String policyNumber) {
        return new PolicyValidationStatus(Status.CHANGE_POLICY_NUMBER, policyNumber);
    }

    public static PolicyValidationStatus unsupported() {
        return new PolicyValidationStatus(Status.UNSUPPORTED);
    }

    public static enum Status {
        VALID,
        INVALID,
        NOT_FOUND,
        EXPIRED,
        CHANGE_POLICY_NUMBER,
        UNSUPPORTED;

    }
}

