/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.claim;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.List;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.domain.patient.Patient;
import org.openvpms.domain.practice.Location;
import org.openvpms.insurance.claim.Attachment;
import org.openvpms.insurance.claim.ClaimHandler;
import org.openvpms.insurance.claim.ClaimUpdater;
import org.openvpms.insurance.claim.Condition;
import org.openvpms.insurance.claim.Note;
import org.openvpms.insurance.policy.Policy;

public interface Claim {
    public long getId();

    public String getInsurerId();

    public void setInsurerId(String var1, String var2);

    public OffsetDateTime getCreated();

    public OffsetDateTime getCompleted();

    public BigDecimal getDiscount();

    public BigDecimal getDiscountTax();

    public BigDecimal getTotal();

    public BigDecimal getTotalTax();

    public BigDecimal getCurrentPaid();

    public BigDecimal getCurrentBalance();

    public Patient getAnimal();

    public Policy getPolicy();

    public Policy setPolicy(Party var1, String var2);

    public Status getStatus();

    public void setStatus(Status var1);

    public void setStatus(Status var1, String var2);

    public List<Condition> getConditions();

    public List<Note> getClinicalHistory();

    public List<Attachment> getAttachments();

    public User getClinician();

    public ClaimHandler getClaimHandler();

    public Location getLocation();

    public void setMessage(String var1);

    public String getMessage();

    public boolean canCancel();

    public void finalise();

    public ClaimUpdater state();

    public static enum Status {
        PENDING,
        POSTED,
        SUBMITTED,
        ACCEPTED,
        SETTLED,
        DECLINED,
        CANCELLING,
        CANCELLED;


        public boolean isA(String status) {
            return this.name().equals(status);
        }
    }
}

