/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.service;

public class ClaimValidationStatus {
    private final Status status;
    private final String message;

    private ClaimValidationStatus(Status status) {
        this(status, null);
    }

    private ClaimValidationStatus(Status status, String message) {
        this.status = status;
        this.message = message;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public static ClaimValidationStatus valid() {
        return new ClaimValidationStatus(Status.VALID);
    }

    public static ClaimValidationStatus warning(String message) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 'message' must be provided");
        }
        return new ClaimValidationStatus(Status.WARNING, message);
    }

    public static ClaimValidationStatus error(String message) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 'message' must be provided");
        }
        return new ClaimValidationStatus(Status.ERROR, message);
    }

    public static enum Status {
        VALID,
        WARNING,
        ERROR;

    }
}

