/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.patient;

import java.util.Date;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.hl7.patient.PatientContext;

public class PatientContextFactory {
    private final PatientRules patientRules;
    private final CustomerRules customerRules;
    private final MedicalRecordRules recordRules;
    private final IArchetypeService service;
    private final LookupService lookups;

    public PatientContextFactory(PatientRules patientRules, CustomerRules customerRules, MedicalRecordRules recordRules, IArchetypeService service, LookupService lookups) {
        this.patientRules = patientRules;
        this.customerRules = customerRules;
        this.recordRules = recordRules;
        this.service = service;
        this.lookups = lookups;
    }

    public PatientContext createContext(Act visit, Party location) {
        PatientContext result = null;
        IMObjectBean bean = this.service.getBean((IMObject)visit);
        Party patient = (Party)bean.getTarget("patient", Party.class);
        if (patient != null) {
            Party visitLocation = (Party)bean.getTarget("location", Party.class);
            if (visitLocation != null) {
                location = visitLocation;
            }
            result = this.createContext(patient, visit, location);
        }
        return result;
    }

    public PatientContext createContext(Party patient, Party location) {
        PatientContext result = null;
        Act visit = this.recordRules.getEvent(patient, new Date(), location);
        if (visit != null) {
            result = this.createContext(patient, visit, location);
        }
        return result;
    }

    public PatientContext createContext(Party patient, Party customer, Party location) {
        PatientContext result = null;
        Act visit = this.recordRules.getEvent(patient, new Date(), location);
        if (visit != null) {
            result = this.createContext(patient, customer, visit, location);
        }
        return result;
    }

    public PatientContext createContext(Party patient, Act visit, Party location) {
        Party customer = this.patientRules.getOwner(patient, visit.getActivityStartTime(), false);
        return this.createContext(patient, customer, visit, location);
    }

    public PatientContext createContext(Party patient, Party customer, Act visit, Party location) {
        IMObjectBean bean = this.service.getBean((IMObject)visit);
        User clinician = (User)bean.getTarget("clinician", User.class);
        return this.createContext(patient, customer, visit, location, clinician);
    }

    public PatientContext createContext(Party patient, Party customer, Act visit, Party location, User clinician) {
        return new PatientContext(patient, customer, visit, location, clinician, this.patientRules, this.customerRules, this.service, this.lookups);
    }
}

