/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.patient;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.math.Weight;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.lookup.LookupService;

public class PatientContext {
    private final Party patient;
    private final Party customer;
    private final Act visit;
    private final Party location;
    private final User clinician;
    private final PatientRules patientRules;
    private final CustomerRules customerRules;
    private final IMObjectBean patientBean;
    private final IMObjectBean customerBean;
    private final LookupService lookups;
    private String clinicianFirstName;
    private String clinicianLastName;
    private Act weight;
    private boolean initAlerts = false;
    private List<Act> allergies = null;
    private boolean aggressive = false;

    public PatientContext(Party patient, Party customer, Act visit, Party location, User clinician, PatientRules patientRules, CustomerRules customerRules, IArchetypeService service, LookupService lookups) {
        this.patient = patient;
        this.customer = customer;
        this.visit = visit;
        this.location = location;
        this.clinician = clinician;
        this.patientRules = patientRules;
        this.customerRules = customerRules;
        this.lookups = lookups;
        this.patientBean = service.getBean((IMObject)patient);
        IMObjectBean iMObjectBean = this.customerBean = customer != null ? service.getBean((IMObject)customer) : null;
        if (clinician != null) {
            IMObjectBean clinicianBean = service.getBean((IMObject)clinician);
            this.clinicianFirstName = clinicianBean.getString("firstName");
            this.clinicianLastName = clinicianBean.getString("lastName");
            if (this.clinicianFirstName == null && this.clinicianLastName == null) {
                String[] firstLast = clinician.getName().split(" ", 2);
                if (firstLast.length == 2) {
                    this.clinicianFirstName = firstLast[0];
                    this.clinicianLastName = firstLast[1];
                } else if (firstLast.length == 1) {
                    this.clinicianLastName = firstLast[0];
                }
            }
        }
    }

    public Party getLocation() {
        return this.location;
    }

    public Act getVisit() {
        return this.visit;
    }

    public long getVisitId() {
        return this.visit.getId();
    }

    public Date getVisitStartTime() {
        return this.visit.getActivityStartTime();
    }

    public Date getVisitEndTime() {
        return this.visit.getActivityEndTime();
    }

    public Party getPatient() {
        return this.patient;
    }

    public long getPatientId() {
        return this.patient.getId();
    }

    public String getPatientFirstName() {
        return this.patient.getName();
    }

    public String getPatientLastName() {
        return this.customerBean != null ? this.customerBean.getString("lastName") : null;
    }

    public String getPatientSex() {
        return this.patientBean.getString("sex");
    }

    public boolean isDesexed() {
        return this.patientBean.getBoolean("desexed");
    }

    public Date getDateOfBirth() {
        return this.patientRules.getDateOfBirth(this.patient);
    }

    public Weight getWeight() {
        this.getWeightAct();
        return this.weight != null ? this.patientRules.getWeight(this.weight) : null;
    }

    public String getHomePhone() {
        String phone;
        String result = null;
        if (this.customer != null && !StringUtils.isEmpty((CharSequence)(phone = this.customerRules.getHomeTelephone(this.customer)))) {
            result = phone;
        }
        return result;
    }

    public String getWorkPhone() {
        String phone;
        String result = null;
        if (this.customer != null && !StringUtils.isEmpty((CharSequence)(phone = this.customerRules.getWorkTelephone(this.customer)))) {
            result = phone;
        }
        return result;
    }

    public String getMobilePhone() {
        String phone;
        String result = null;
        if (this.customer != null && !StringUtils.isEmpty((CharSequence)(phone = this.customerRules.getMobileTelephone(this.customer)))) {
            result = phone;
        }
        return result;
    }

    public String getFax() {
        String fax;
        String result = null;
        if (this.customer != null && !StringUtils.isEmpty((CharSequence)(fax = this.customerRules.getFaxNumber(this.customer)))) {
            result = fax;
        }
        return result;
    }

    public String getEmail() {
        String email;
        String result = null;
        if (this.customer != null && !StringUtils.isEmpty((CharSequence)(email = this.customerRules.getEmailAddress(this.customer)))) {
            result = email;
        }
        return result;
    }

    public String getSpeciesCode() {
        return this.patientBean.getString("species");
    }

    public String getSpeciesName() {
        return this.lookups.getName((IMObject)this.patient, "species");
    }

    public String getBreedCode() {
        return this.patientBean.getString("breed");
    }

    public String getBreedName() {
        return this.lookups.getName((IMObject)this.patient, "breed");
    }

    public Party getCustomer() {
        return this.customer;
    }

    public long getCustomerId() {
        return this.customer != null ? this.customer.getId() : -1L;
    }

    public String getLocationName() {
        return this.location.getName();
    }

    public User getClinician() {
        return this.clinician;
    }

    public long getClinicianId() {
        return this.clinician != null ? this.clinician.getId() : -1L;
    }

    public String getClinicianFirstName() {
        return this.clinicianFirstName;
    }

    public String getClinicianLastName() {
        return this.clinicianLastName;
    }

    public Contact getAddress() {
        return this.customer != null ? this.customerRules.getAddressContact(this.customer, "HOME") : null;
    }

    public List<Act> getAllergies() {
        this.getAlerts();
        return new ArrayList<Act>(this.allergies);
    }

    public boolean isAggressive() {
        this.getAlerts();
        return this.aggressive;
    }

    private void getWeightAct() {
        if (this.weight == null) {
            this.weight = this.patientRules.getWeightAct(this.patient);
        }
    }

    private void getAlerts() {
        if (!this.initAlerts) {
            this.allergies = this.patientRules.getAllergies(this.patient, new Date());
            this.aggressive = this.patientRules.isAggressive(this.patient);
            this.initAlerts = true;
        }
    }
}

