/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.io;

import java.util.Objects;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.hl7.impl.HL7Mapping;

public abstract class Connector {
    private final String sendingApplication;
    private final String sendingFacility;
    private final String receivingApplication;
    private final String receivingFacility;
    private final Reference reference;
    private final HL7Mapping mapping;

    public Connector(String sendingApplication, String sendingFacility, String receivingApplication, String receivingFacility, Reference reference, HL7Mapping mapping) {
        this.sendingApplication = sendingApplication;
        this.sendingFacility = sendingFacility;
        this.receivingApplication = receivingApplication;
        this.receivingFacility = receivingFacility;
        this.reference = reference;
        this.mapping = mapping;
    }

    public String getSendingApplication() {
        return this.sendingApplication;
    }

    public String getSendingFacility() {
        return this.sendingFacility;
    }

    public String getReceivingApplication() {
        return this.receivingApplication;
    }

    public String getReceivingFacility() {
        return this.receivingFacility;
    }

    public Reference getReference() {
        return this.reference;
    }

    public HL7Mapping getMapping() {
        return this.mapping;
    }

    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (!result && obj instanceof Connector) {
            Connector other = (Connector)obj;
            result = Objects.equals(this.sendingApplication, other.sendingApplication) && Objects.equals(this.sendingFacility, other.sendingFacility) && Objects.equals(this.receivingApplication, other.receivingApplication) && Objects.equals(this.receivingFacility, other.receivingFacility);
        }
        return result;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        return this.hashCode(builder).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("reference", (Object)this.reference).toString();
    }

    protected HashCodeBuilder hashCode(HashCodeBuilder builder) {
        return builder.append((Object)this.sendingApplication).append((Object)this.sendingFacility).append((Object)this.receivingApplication).append((Object)this.receivingFacility);
    }

    protected static HL7Mapping getMapping(IMObjectBean bean, ArchetypeService service) {
        Entity object = (Entity)bean.getTarget("mapping", Entity.class);
        return object != null ? HL7Mapping.create(object, service) : new HL7Mapping();
    }
}

