/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import ca.uhn.hl7v2.AcknowledgmentCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.HL7Service;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.v25.datatype.DTM;
import ca.uhn.hl7v2.model.v25.datatype.HD;
import ca.uhn.hl7v2.model.v25.message.ACK;
import ca.uhn.hl7v2.model.v25.segment.MSA;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import ca.uhn.hl7v2.protocol.ReceivingApplication;
import ca.uhn.hl7v2.protocol.ReceivingApplicationException;
import ca.uhn.hl7v2.protocol.ReceivingApplicationExceptionHandler;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.openvpms.component.business.service.security.RunAs;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.user.User;
import org.openvpms.hl7.impl.HL7Mapping;
import org.openvpms.hl7.impl.HL7MessageHelper;
import org.openvpms.hl7.impl.PopulateHelper;
import org.openvpms.hl7.io.Connector;
import org.openvpms.hl7.io.MessageService;
import org.openvpms.hl7.io.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MessageReceiver
implements ReceivingApplication,
ReceivingApplicationExceptionHandler,
Statistics {
    private final Connector connector;
    private final ReceivingApplication receiver;
    private final MessageService service;
    private final User user;
    private final HL7Mapping mapping;
    private final HL7Service hl7Service;
    private Date lastReceived;
    private Date lastError;
    private String lastErrorMessage;
    private static final String META_DATA_KEY = MessageReceiver.class.getName() + ".act";
    private static final Logger log = LoggerFactory.getLogger(MessageReceiver.class);

    public MessageReceiver(ReceivingApplication receiver, Connector connector, MessageService service, User user, HL7Service hl7Service) {
        this.connector = connector;
        this.mapping = connector.getMapping();
        this.receiver = receiver;
        this.service = service;
        this.user = user;
        this.hl7Service = hl7Service;
    }

    public ReceivingApplication getReceivingApplication() {
        return this.receiver;
    }

    public User getUser() {
        return this.user;
    }

    public Message processMessage(Message message, Map<String, Object> metaData) throws ReceivingApplicationException, HL7Exception {
        Message response;
        MSH msh = this.getMSH(message);
        this.check("MSH-3: Sending Application", this.connector.getSendingApplication(), msh.getSendingApplication());
        this.check("MSH-4: Sending Facility", this.connector.getSendingFacility(), msh.getSendingFacility());
        this.check("MSH-5: Receiving Application", this.connector.getReceivingApplication(), msh.getReceivingApplication());
        this.check("MSH-6: Receiving Facility", this.connector.getReceivingFacility(), msh.getReceivingFacility());
        Callable<Message> callable = () -> this.process(message, metaData);
        try {
            response = (Message)RunAs.run((User)this.user, callable);
        }
        catch (HL7Exception | ReceivingApplicationException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new HL7Exception((Throwable)exception);
        }
        return response;
    }

    public boolean canProcess(Message theMessage) {
        return this.receiver.canProcess(theMessage);
    }

    public String processException(String incomingMessage, Map<String, Object> incomingMetadata, String outgoingMessage, Exception exception) {
        DocumentAct act = (DocumentAct)incomingMetadata.get(META_DATA_KEY);
        if (act != null) {
            this.error(act, exception);
        } else {
            log.error(exception.getMessage(), (Throwable)exception);
            this.error(exception.getMessage(), new Date());
        }
        return outgoingMessage;
    }

    @Override
    public int getQueued() {
        return 0;
    }

    @Override
    public int getErrors() {
        return 0;
    }

    @Override
    public boolean isRunning() {
        return this.hl7Service.isRunning();
    }

    @Override
    public synchronized Date getProcessedTimestamp() {
        return this.lastReceived;
    }

    @Override
    public synchronized Date getErrorTimestamp() {
        return this.lastError;
    }

    @Override
    public synchronized String getErrorMessage() {
        return this.lastErrorMessage;
    }

    @Override
    public Connector getConnector() {
        return this.connector;
    }

    private void check(String name, String expected, HD actual) throws HL7Exception {
        String value = actual.getNamespaceID().getValue();
        if (!Objects.equals(expected, value)) {
            log.error("Unrecognised value for " + name + ": '" + value + "'");
            throw new HL7Exception("Unrecognised application details");
        }
    }

    private Message process(Message message, Map<String, Object> metaData) throws HL7Exception, ReceivingApplicationException {
        Message response;
        DocumentAct act = this.service.save(message, this.connector);
        metaData.put(META_DATA_KEY, act);
        try {
            response = this.receiver.processMessage(message, metaData);
            if (!this.mapping.includeMillis() || !this.mapping.includeTimeZone()) {
                try {
                    MSH msh = this.getMSH(response);
                    DTM time = msh.getDateTimeOfMessage().getTime();
                    Calendar calendar = time.getValueAsCalendar();
                    PopulateHelper.populateDTM(time, calendar, this.mapping);
                }
                catch (HL7Exception msh) {
                    // empty catch block
                }
            }
            if (this.isAccepted(response)) {
                this.service.accepted(act, new Date());
                this.processed();
            } else {
                this.error(act, this.getError(response));
            }
        }
        catch (HL7Exception | ReceivingApplicationException exception) {
            this.error(act, exception);
            throw exception;
        }
        catch (Throwable exception) {
            this.error(act, exception);
            throw new ReceivingApplicationException(exception);
        }
        return response;
    }

    private MSH getMSH(Message message) throws HL7Exception {
        return (MSH)message.get("MSH");
    }

    private void error(DocumentAct act, Throwable exception) {
        String message = exception.getMessage();
        log.error(message, exception);
        this.error(act, message);
    }

    private void error(DocumentAct act, String message) {
        Date timestamp = new Date();
        this.service.error(act, "ERROR", timestamp, message);
        this.error(message, timestamp);
    }

    private synchronized void processed() {
        this.lastReceived = new Date();
        this.lastError = null;
        this.lastErrorMessage = null;
    }

    private synchronized void error(String message, Date timestamp) {
        this.lastErrorMessage = message;
        this.lastError = timestamp;
    }

    private boolean isAccepted(Message response) {
        boolean result = false;
        if (response instanceof ACK) {
            ACK ack = (ACK)response;
            MSA msa = ack.getMSA();
            String ackCode = msa.getAcknowledgmentCode().getValue();
            if (AcknowledgmentCode.AA.toString().equals(ackCode)) {
                result = true;
            }
        }
        return result;
    }

    private String getError(Message response) {
        if (response instanceof ACK) {
            return HL7MessageHelper.getErrorMessage(response);
        }
        return "Unknown error";
    }
}

