/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import ca.uhn.hl7v2.HapiContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openvpms.archetype.component.dispatcher.Queues;
import org.openvpms.component.model.object.Reference;
import org.openvpms.hl7.impl.MLLPSender;
import org.openvpms.hl7.impl.MessageQueue;
import org.openvpms.hl7.io.MessageService;
import org.openvpms.hl7.io.Statistics;

class MessageQueues
implements Queues<MLLPSender, MessageQueue> {
    private final MessageService messageService;
    private final HapiContext messageContext;
    private final Map<Reference, MessageQueue> queues = Collections.synchronizedMap(new HashMap());

    public MessageQueues(MessageService messageService, HapiContext messageContext) {
        this.messageService = messageService;
        this.messageContext = messageContext;
    }

    public List<MessageQueue> getQueues() {
        return new ArrayList<MessageQueue>(this.queues.values());
    }

    public MessageQueue getQueue(MLLPSender owner) {
        return this.getQueue(owner, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageQueue getQueue(MLLPSender owner, boolean create) {
        MessageQueue queue;
        Map<Reference, MessageQueue> map = this.queues;
        synchronized (map) {
            Reference reference = owner.getReference();
            queue = this.queues.get(reference);
            if (queue == null && create) {
                queue = new MessageQueue(owner, this.messageService, this.messageContext);
                this.queues.put(reference, queue);
            }
        }
        return queue;
    }

    public Statistics getStatistics(Reference sender) {
        return this.queues.get(sender);
    }

    public MessageQueue remove(Reference reference) {
        return this.queues.remove(reference);
    }

    public void destroy() {
        this.queues.clear();
    }
}

