/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.NM;
import ca.uhn.hl7v2.model.v25.message.ADT_A01;
import ca.uhn.hl7v2.model.v25.message.ADT_A03;
import ca.uhn.hl7v2.model.v25.message.ADT_A09;
import ca.uhn.hl7v2.model.v25.segment.OBX;
import org.openvpms.component.math.Weight;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.hl7.impl.AbstractMessageFactory;
import org.openvpms.hl7.impl.HL7Mapping;
import org.openvpms.hl7.impl.PopulateHelper;
import org.openvpms.hl7.patient.PatientContext;

public class ADTMessageFactory
extends AbstractMessageFactory {
    private static final String BODY_WEIGHT_MEASURED = "3141-9";

    public ADTMessageFactory(HapiContext messageContext, ArchetypeService service, LookupService lookups) {
        super(messageContext, service, lookups);
    }

    public Message createAdmit(PatientContext context, HL7Mapping config) {
        return this.createADT_A01(context, "A01", config);
    }

    public Message createCancelAdmit(PatientContext context, HL7Mapping config) {
        ADT_A09 adt = new ADT_A09(this.getModelClassFactory());
        try {
            this.init((AbstractMessage)adt, "ADT", "A11");
            this.populate(adt.getPID(), context, config);
            this.populate(adt.getPV1(), context, config);
            Weight weight = context.getWeight();
            if (weight != null) {
                OBX obx = adt.getOBX(0);
                this.populateWeight(obx, context, (Message)adt, weight, config);
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception.getMessage());
        }
        return adt;
    }

    public Message createDischarge(PatientContext context, HL7Mapping config) {
        ADT_A03 adt = new ADT_A03(this.getModelClassFactory());
        try {
            this.init((AbstractMessage)adt, "ADT", "A03");
            this.populate(adt.getPID(), context, config);
            this.populate(adt.getPV1(), context, config);
            Weight weight = context.getWeight();
            if (weight != null) {
                OBX obx = adt.getOBX(0);
                this.populateWeight(obx, context, (Message)adt, weight, config);
            }
            this.populateAllergies((Group)adt, context);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception.getMessage(), exception);
        }
        return adt;
    }

    public Message createUpdate(PatientContext context, HL7Mapping config) {
        return this.createADT_A01(context, "A08", config);
    }

    private Message createADT_A01(PatientContext context, String triggerEvent, HL7Mapping config) {
        ADT_A01 adt = new ADT_A01(this.getModelClassFactory());
        try {
            this.init((AbstractMessage)adt, "ADT", triggerEvent);
            this.populate(adt.getPID(), context, config);
            this.populate(adt.getPV1(), context, config);
            Weight weight = context.getWeight();
            if (weight != null) {
                OBX obx = adt.getOBX(0);
                this.populateWeight(obx, context, (Message)adt, weight, config);
            }
            this.populateAllergies((Group)adt, context);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception.getMessage());
        }
        return adt;
    }

    private void populateWeight(OBX obx, PatientContext context, Message message, Weight weight, HL7Mapping config) throws DataTypeException {
        obx.getSetIDOBX().setValue("1");
        obx.getValueType().setValue("NM");
        CE identifier = obx.getObservationIdentifier();
        identifier.getIdentifier().setValue(BODY_WEIGHT_MEASURED);
        identifier.getText().setValue("BODY WEIGHT MEASURED");
        identifier.getNameOfCodingSystem().setValue("LN");
        NM nm = new NM(message);
        Varies observationValue = obx.getObservationValue(0);
        nm.setValue(weight.toKilograms().toString());
        observationValue.setData((Type)nm);
        PopulateHelper.populateDTM(obx.getDateTimeOfTheObservation().getTime(), weight.getDate(), config);
        obx.getUnits().getIdentifier().setValue("kg");
        obx.getUnits().getText().setValue("kilogram");
    }
}

