/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.protocol.ReceivingApplication;
import ca.uhn.hl7v2.protocol.ReceivingApplicationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.user.User;
import org.openvpms.hl7.io.Connector;
import org.openvpms.hl7.io.Connectors;
import org.openvpms.hl7.io.MessageDispatcher;
import org.openvpms.hl7.service.Services;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public abstract class ServicesMessageReceiver
implements DisposableBean {
    private final Services services;
    private final MessageDispatcher dispatcher;
    private final Connectors connectors;
    private final IArchetypeService service;
    private final Services.Listener listener;
    private final Map<Long, Connector> listening = Collections.synchronizedMap(new HashMap());
    private static final Logger log = LoggerFactory.getLogger(ServicesMessageReceiver.class);

    public ServicesMessageReceiver(Services services, IArchetypeService service, MessageDispatcher dispatcher, Connectors connectors) {
        this.services = services;
        this.service = service;
        this.dispatcher = dispatcher;
        this.connectors = connectors;
        this.listener = new Services.Listener(){

            @Override
            public void added(Entity service) {
                ServicesMessageReceiver.this.listen(service, true);
            }

            @Override
            public void removed(Entity service) {
                ServicesMessageReceiver.this.stop(service);
            }
        };
    }

    public void destroy() {
        this.services.removeListener(this.listener);
        List<Connector> connectors = this.getConnectors();
        for (Connector connector : connectors) {
            this.dispatcher.stop(connector);
        }
    }

    public abstract boolean canProcess(Message var1);

    public abstract void process(Message var1, Reference var2) throws HL7Exception;

    protected void listen() {
        for (Entity service : this.services.getServices()) {
            this.listen(service, false);
        }
        this.services.addListener(this.listener);
        this.dispatcher.start();
    }

    protected List<Connector> getConnectors() {
        return new ArrayList<Connector>(this.listening.values());
    }

    protected IArchetypeService getService() {
        return this.service;
    }

    protected Message processMessage(Message message, Reference reference) throws ReceivingApplicationException, HL7Exception {
        Message response;
        this.log(message);
        Entity entity = this.services.getService(reference);
        if (entity == null) {
            throw new ReceivingApplicationException("Service not found: " + reference);
        }
        IMObjectBean bean = this.service.getBean((IMObject)entity);
        Reference location = bean.getTargetRef("location");
        try {
            this.process(message, location);
            response = message.generateACK();
        }
        catch (HL7Exception exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new HL7Exception((Throwable)exception);
        }
        return response;
    }

    private void listen(Entity service, boolean start) {
        Connector current = this.listening.get(service.getId());
        IMObjectBean bean = this.service.getBean((IMObject)service);
        Connector connector = this.getConnector(bean);
        User user = this.getUser(bean);
        boolean listen = true;
        if (current != null && connector != null) {
            if (!current.equals(connector)) {
                this.stop(service);
            } else {
                listen = false;
            }
        }
        if (connector != null && user != null) {
            if (listen) {
                try {
                    this.dispatcher.listen(connector, new Receiver(service), user);
                    if (start) {
                        this.dispatcher.start();
                    }
                    this.listening.put(service.getId(), connector);
                }
                catch (Throwable exception) {
                    log.warn("Failed to start listening to connections from service, name=" + service.getName() + ", id=" + service.getId() + ")", exception);
                }
            }
        } else if (current != null) {
            this.stop(service);
        } else {
            log.info("Service (name=" + service.getName() + ", id=" + service.getId() + ") has no receiver connection or user defined, skipping");
        }
    }

    private void stop(Entity service) {
        Connector connector = this.listening.remove(service.getId());
        if (connector != null) {
            log.info("Stopping listener for service (name=" + service.getName() + ", id=" + service.getId() + ")");
            this.dispatcher.stop(connector);
        }
    }

    private Connector getConnector(IMObjectBean service) {
        Reference ref = service.getTargetRef("receiver");
        return ref != null ? this.connectors.getConnector(ref) : null;
    }

    private User getUser(IMObjectBean service) {
        return (User)service.getTarget("user", User.class);
    }

    private void log(Message message) {
        if (log.isDebugEnabled()) {
            String formatted;
            try {
                formatted = message.encode();
                formatted = formatted.replaceAll("\\r", "\n");
            }
            catch (HL7Exception exception) {
                formatted = exception.getMessage();
            }
            log.debug("Received message: \n" + formatted);
        }
    }

    private class Receiver
    implements ReceivingApplication {
        private final Reference reference;

        Receiver(Entity entity) {
            this.reference = entity.getObjectReference();
        }

        public Message processMessage(Message message, Map<String, Object> theMetadata) throws ReceivingApplicationException, HL7Exception {
            return ServicesMessageReceiver.this.processMessage(message, this.reference);
        }

        public boolean canProcess(Message theMessage) {
            return ServicesMessageReceiver.this.canProcess(theMessage);
        }
    }
}

