/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.DTM;
import ca.uhn.hl7v2.model.v25.datatype.XCN;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.openvpms.component.model.product.Product;
import org.openvpms.hl7.impl.HL7Mapping;
import org.openvpms.hl7.patient.PatientContext;

public class PopulateHelper {
    public static void populateDTM(DTM dtm, Calendar value, HL7Mapping config) throws DataTypeException {
        String formatted;
        int index;
        if (!config.includeMillis()) {
            value.set(14, 0);
        }
        dtm.setValue(value);
        if (!config.includeTimeZone() && (index = (formatted = dtm.getValue()).indexOf("+")) != -1) {
            formatted = formatted.substring(0, index);
            dtm.setValue(formatted);
        }
    }

    public static void populateDTM(DTM dtm, Date value, HL7Mapping config) throws DataTypeException {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(value);
        PopulateHelper.populateDTM(dtm, calendar, config);
    }

    public static void populateClinician(XCN xcn, PatientContext context) throws DataTypeException {
        xcn.getIDNumber().setValue(Long.toString(context.getClinicianId()));
        xcn.getGivenName().setValue(context.getClinicianFirstName());
        xcn.getFamilyName().getSurname().setValue(context.getClinicianLastName());
    }

    public static void populateProduct(CE ce, Product product) throws DataTypeException {
        PopulateHelper.populateCE(ce, product.getId(), product.getName());
    }

    public static void populateCE(CE ce, long id, String text) throws DataTypeException {
        PopulateHelper.populateCE(ce, Long.toString(id), text);
    }

    public static void populateCE(CE ce, String id, String text) throws DataTypeException {
        PopulateHelper.populateCE(ce, id, text, "OpenVPMS");
    }

    public static void populateCE(CE ce, String id, String text, String codingSystem) throws DataTypeException {
        ce.getIdentifier().setValue(id);
        ce.getText().setValue(text);
        ce.getNameOfCodingSystem().setValue(codingSystem);
    }
}

