/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.v25.message.RDS_O13;
import java.util.List;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.Reference;
import org.openvpms.hl7.impl.RDSProcessor;
import org.openvpms.hl7.impl.ServicesMessageReceiver;
import org.openvpms.hl7.io.Connectors;
import org.openvpms.hl7.io.MessageDispatcher;
import org.openvpms.hl7.pharmacy.Pharmacies;

public class PharmacyDispenseServiceImpl
extends ServicesMessageReceiver {
    private final RDSProcessor processor;

    public PharmacyDispenseServiceImpl(Pharmacies pharmacies, MessageDispatcher dispatcher, Connectors connectors, IArchetypeService service, PatientRules rules, UserRules userRules) {
        super(pharmacies, service, dispatcher, connectors);
        this.processor = new RDSProcessor(service, rules, userRules);
        this.listen();
    }

    @Override
    public boolean canProcess(Message message) {
        return message instanceof RDS_O13;
    }

    @Override
    public void process(Message message, Reference location) throws HL7Exception {
        this.process((RDS_O13)message, location);
    }

    protected List<Act> process(RDS_O13 message, Reference location) throws HL7Exception {
        List<Act> order = this.processor.process(message, location);
        this.getService().save(order);
        return order;
    }
}

