/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.MonitoringIMObjectCache;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.hl7.io.Connector;
import org.openvpms.hl7.io.Connectors;
import org.openvpms.hl7.patient.PatientEventServices;

public class PatientEventServicesImpl
extends MonitoringIMObjectCache<Entity>
implements PatientEventServices {
    private final Connectors connectors;

    public PatientEventServicesImpl(IArchetypeService service, Connectors connectors) {
        super(service, "entity.HL7ServicePatientEvent", Entity.class, false);
        this.connectors = connectors;
        this.load();
    }

    @Override
    public void add(Entity service) {
        this.addObject((IMObject)service);
    }

    @Override
    public void remove(Entity service) {
        this.removeObject((IMObject)service);
    }

    @Override
    public Collection<Connector> getConnections(Party location) {
        return this.getConnections(location.getObjectReference());
    }

    @Override
    public Collection<Connector> getConnections(Reference location) {
        HashMap<Reference, Connector> result = new HashMap<Reference, Connector>();
        for (Entity object : this.getObjects()) {
            Connector connector;
            Reference sender;
            IMObjectBean bean = this.getService().getBean((IMObject)object);
            if (!Objects.equals(bean.getTargetRef("location"), location) || (sender = bean.getTargetRef("sender")) == null || result.containsKey(sender) || (connector = this.connectors.getConnector(sender)) == null) continue;
            result.put(sender, connector);
        }
        return result.values();
    }
}

