/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v25.message.ORM_O01;
import ca.uhn.hl7v2.model.v25.segment.OBR;
import ca.uhn.hl7v2.model.v25.segment.ORC;
import java.util.Date;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.hl7.impl.AbstractMessageFactory;
import org.openvpms.hl7.impl.HL7Mapping;
import org.openvpms.hl7.impl.PopulateHelper;
import org.openvpms.hl7.patient.PatientContext;

public class ORMMessageFactory
extends AbstractMessageFactory {
    public ORMMessageFactory(HapiContext messageContext, ArchetypeService service, LookupService lookups) {
        super(messageContext, service, lookups);
    }

    public ORM_O01 createOrder(PatientContext context, long placerOrderNumber, String serviceId, Date date, HL7Mapping config) {
        ORM_O01 orm = this.create(context, "NW", placerOrderNumber, serviceId, date, config);
        return orm;
    }

    public ORM_O01 cancelOrder(PatientContext context, long placerOrderNumber, String serviceId, Date date, HL7Mapping config) {
        ORM_O01 orm = this.create(context, "CA", placerOrderNumber, serviceId, date, config);
        return orm;
    }

    private ORM_O01 create(PatientContext context, String orderControl, long placerOrderNumber, String serviceId, Date date, HL7Mapping config) {
        ORM_O01 orm;
        try {
            orm = new ORM_O01(this.getModelClassFactory());
            this.init((AbstractMessage)orm, "ORM", "O01");
            this.populate(orm.getPATIENT().getPID(), context, config);
            this.populate(orm.getPATIENT().getPATIENT_VISIT().getPV1(), context, config);
            ORC orc = orm.getORDER().getORC();
            orc.getOrderControl().setValue(orderControl);
            String number = Long.toString(placerOrderNumber);
            orc.getPlacerOrderNumber().getEntityIdentifier().setValue(number);
            PopulateHelper.populateDTM(orc.getDateTimeOfTransaction().getTime(), date, config);
            OBR obr = orm.getORDER().getORDER_DETAIL().getOBR();
            obr.getSetIDOBR().setValue("1");
            obr.getPlacerOrderNumber().getEntityIdentifier().setValue(number);
            obr.getUniversalServiceIdentifier().getIdentifier().setValue(serviceId);
            PopulateHelper.populateDTM(obr.getRequestedDateTime().getTime(), date, config);
            if (context.getClinicianId() != -1L) {
                PopulateHelper.populateClinician(orc.getOrderingProvider(0), context);
            }
            this.populateAllergies((Group)orm.getPATIENT(), context);
        }
        catch (Throwable exception) {
            throw new IllegalStateException(exception);
        }
        return orm;
    }
}

