/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.v25.datatype.TS;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import ca.uhn.hl7v2.parser.Parser;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.hl7.impl.HL7MessageHelper;
import org.openvpms.hl7.io.Connector;
import org.openvpms.hl7.io.HL7DocumentHandler;
import org.openvpms.hl7.io.MessageService;

public class MessageServiceImpl
implements MessageService {
    private final IArchetypeService service;
    private final HL7DocumentHandler handler;
    private static final String MIME_TYPE = "application/hl7-v2+er7";
    private static final int MAX_ERROR_LENGTH = 5000;

    public MessageServiceImpl(IArchetypeService service) {
        this.service = service;
        this.handler = new HL7DocumentHandler(service);
    }

    @Override
    public DocumentAct save(Message message, Connector connector) throws HL7Exception {
        DocumentAct act = (DocumentAct)this.service.create("act.HL7Message", DocumentAct.class);
        IMObjectBean bean = this.service.getBean((IMObject)act);
        bean.setTarget("connector", connector.getReference());
        bean.setValue("hl7Version", (Object)message.getVersion());
        MSH header = (MSH)message.get("MSH");
        String name = HL7MessageHelper.getMessageName(header);
        act.setName(name);
        TS dateTimeOfMessage = header.getDateTimeOfMessage();
        act.setActivityStartTime(dateTimeOfMessage.getTime().getValueAsDate());
        name = name + "_" + header.getMessageControlID().getValue() + ".hl7";
        String encoded = message.encode();
        Document document = this.handler.create(name, encoded, MIME_TYPE);
        act.setDocument((Reference)document.getObjectReference());
        List<IMObject> toSave = Arrays.asList(document, act);
        this.service.save(toSave);
        return act;
    }

    @Override
    public void accepted(DocumentAct message, Date timestamp) {
        message.setActivityEndTime(timestamp);
        message.setStatus("ACCEPTED");
        IMObjectBean bean = this.service.getBean((IMObject)message);
        bean.setValue("error", null);
        bean.save();
    }

    @Override
    public void error(DocumentAct message, String status, Date timestamp, String error) {
        if (error != null && error.length() > 5000) {
            error = error.substring(0, 5000);
        }
        message.setActivityEndTime(timestamp);
        message.setStatus(status);
        IMObjectBean bean = this.service.getBean((IMObject)message);
        bean.setValue("error", (Object)error);
        bean.save();
    }

    @Override
    public Message get(DocumentAct message, Parser parser) throws HL7Exception {
        Document document;
        Reference ref = message.getDocument();
        Document document2 = document = ref != null ? (Document)this.service.get(ref, Document.class) : null;
        if (document == null) {
            throw new HL7Exception("No message content", ErrorCode.APPLICATION_INTERNAL_ERROR);
        }
        String content = this.handler.toString(document);
        return parser.parse(content);
    }

    @Override
    public DocumentAct next(Connector connector) {
        ArchetypeQuery query = this.createQuery(connector, "PENDING");
        query.add((IConstraint)Constraints.sort((String)"id"));
        query.setMaxResults(1);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        return iterator.hasNext() ? (DocumentAct)iterator.next() : null;
    }

    @Override
    public void resubmit(DocumentAct message) {
        if (!"ERROR".equals(message.getStatus())) {
            throw new IllegalArgumentException("Cannot resubmit messages with status " + message.getStatus());
        }
        IMObjectBean bean = this.service.getBean((IMObject)message);
        Reference ref = bean.getTargetRef("connector");
        if (!TypeHelper.isA((Reference)ref, (String)"entity.HL7Sender*")) {
            throw new IllegalArgumentException("Cannot resubmit messages using " + ref.getArchetype());
        }
        message.setStatus("PENDING");
        this.service.save((IMObject)message);
    }

    @Override
    public int getMessages(Connector connector, String status) {
        ArchetypeQuery query = this.createQuery(connector, status);
        query.setCountResults(true);
        return this.service.get((IArchetypeQuery)query).getTotalResults();
    }

    private ArchetypeQuery createQuery(Connector connector, String status) {
        ArchetypeQuery query = new ArchetypeQuery("act.HL7Message");
        query.add((IConstraint)Constraints.join((String)"connector").add((IConstraint)Constraints.eq((String)"entity", (Reference)connector.getReference())));
        query.add((IConstraint)Constraints.eq((String)"status", (Object)status));
        return query;
    }
}

