/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.protocol.ReceivingApplication;
import ca.uhn.hl7v2.util.idgenerator.IDGenerator;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openvpms.archetype.component.dispatcher.Dispatcher;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.user.User;
import org.openvpms.hl7.impl.ConnectorsImpl;
import org.openvpms.hl7.impl.DemultiplexingReceiver;
import org.openvpms.hl7.impl.HL7Mapping;
import org.openvpms.hl7.impl.HL7MessageHelper;
import org.openvpms.hl7.impl.HapiContextFactory;
import org.openvpms.hl7.impl.HeaderPopulator;
import org.openvpms.hl7.impl.MLLPReceiver;
import org.openvpms.hl7.impl.MLLPSender;
import org.openvpms.hl7.impl.MessageQueue;
import org.openvpms.hl7.impl.MessageQueues;
import org.openvpms.hl7.impl.MessageReceiver;
import org.openvpms.hl7.io.Connector;
import org.openvpms.hl7.io.Connectors;
import org.openvpms.hl7.io.MessageDispatcher;
import org.openvpms.hl7.io.MessageService;
import org.openvpms.hl7.io.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class MessageDispatcherImpl
extends Dispatcher<Message, MLLPSender, MessageQueue>
implements MessageDispatcher,
InitializingBean {
    private final MessageService messageService;
    private final ConnectorsImpl connectors;
    private final HeaderPopulator populator;
    private final HapiContext messageContext;
    private final IDGenerator generator;
    private final Map<Reference, MessageReceiver> receiverMap = Collections.synchronizedMap(new HashMap());
    private final Map<Integer, DemultiplexingReceiver> receivers = new HashMap<Integer, DemultiplexingReceiver>();
    private final ConnectorsImpl.Listener listener;
    private static final Logger log = LoggerFactory.getLogger(MessageDispatcherImpl.class);

    public MessageDispatcherImpl(MessageService messageService, ConnectorsImpl connectors, PracticeService practiceService) {
        this(messageService, connectors, practiceService, HapiContextFactory.create());
    }

    public MessageDispatcherImpl(MessageService messageService, ConnectorsImpl connectors, PracticeService practiceService, HapiContext context) {
        super(practiceService, log);
        this.messageService = messageService;
        this.connectors = connectors;
        this.populator = new HeaderPopulator();
        this.messageContext = context;
        this.generator = this.messageContext.getParserConfiguration().getIdGenerator();
        this.listener = new ConnectorsImpl.Listener(){

            @Override
            public void added(Connector connector) {
                MessageDispatcherImpl.this.update(connector);
            }

            @Override
            public void removed(Connector connector) {
                MessageDispatcherImpl.this.remove(connector);
            }
        };
        this.init(new MessageQueues(messageService, this.messageContext));
    }

    public HapiContext getMessageContext() {
        return this.messageContext;
    }

    @Override
    public DocumentAct queue(Message message, Connector connector, HL7Mapping config) {
        DocumentAct result;
        if (!(connector instanceof MLLPSender)) {
            throw new IllegalArgumentException("Unsupported connector: " + connector);
        }
        try {
            this.populate(message, (MLLPSender)connector, config);
            result = this.queue(message, (MLLPSender)connector);
        }
        catch (Throwable exception) {
            throw new IllegalStateException(exception);
        }
        return result;
    }

    @Override
    public void resubmit(DocumentAct message) {
        this.messageService.resubmit(message);
        this.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void listen(Connector connector, ReceivingApplication application, User user) throws InterruptedException {
        if (connector instanceof MLLPReceiver) {
            DemultiplexingReceiver receiver;
            int port = ((MLLPReceiver)connector).getPort();
            Map<Integer, DemultiplexingReceiver> map = this.receivers;
            synchronized (map) {
                receiver = this.receivers.get(port);
                if (receiver == null) {
                    receiver = new DemultiplexingReceiver(this.messageService, this.messageContext, port);
                    this.receivers.put(port, receiver);
                }
            }
            MessageReceiver messageReceiver = receiver.add(connector, application, user);
            this.receiverMap.put(connector.getReference(), messageReceiver);
        }
    }

    @Override
    public void start() {
        for (Map.Entry<Integer, DemultiplexingReceiver> entry : this.receivers.entrySet()) {
            DemultiplexingReceiver receiver = entry.getValue();
            if (!receiver.isRunning()) {
                receiver.start();
            }
            if (receiver.isRunning()) continue;
            log.error("Failed to start listener for port=" + entry.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(Connector connector) {
        if (connector instanceof MLLPReceiver) {
            int port = ((MLLPReceiver)connector).getPort();
            Map<Integer, DemultiplexingReceiver> map = this.receivers;
            synchronized (map) {
                DemultiplexingReceiver receiver = this.receivers.get(port);
                if (receiver != null) {
                    DemultiplexingReceiver demultiplexingReceiver = receiver;
                    synchronized (demultiplexingReceiver) {
                        receiver.remove(connector);
                        this.receiverMap.remove(connector.getReference());
                        if (receiver.isEmpty()) {
                            this.receivers.remove(port);
                            receiver.stop();
                        }
                    }
                }
            }
        }
    }

    @Override
    public Statistics getStatistics(Reference connector) {
        Statistics statistics = this.getQueues().getStatistics(connector);
        if (statistics == null) {
            statistics = this.receiverMap.get(connector);
        }
        return statistics;
    }

    public void afterPropertiesSet() {
        this.initialise();
    }

    public void initialise() {
        this.initialise(this.connectors);
        this.connectors.addListener(this.listener);
        log.info("HL7 message dispatcher initialised");
        this.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        this.connectors.removeListener(this.listener);
        super.destroy();
        Map<Integer, DemultiplexingReceiver> map = this.receivers;
        synchronized (map) {
            for (DemultiplexingReceiver receiver : this.receivers.values()) {
                receiver.stop();
            }
        }
        this.messageContext.getExecutorService();
        this.messageContext.close();
    }

    protected MessageQueues getQueues() {
        return (MessageQueues)super.getQueues();
    }

    protected Date createMessageTimestamp() {
        return new Date();
    }

    protected String createMessageControlID() throws IOException {
        return this.generator.getID();
    }

    protected void initialise(Connectors connectors) {
        for (Connector connector : connectors.getConnectors()) {
            if (!(connector instanceof MLLPSender)) continue;
            this.getMessageQueue((MLLPSender)connector);
        }
    }

    protected DocumentAct queue(Message message, MLLPSender sender) throws HL7Exception {
        MessageQueue queue = this.getMessageQueue(sender);
        DocumentAct result = queue.add(message);
        if (log.isDebugEnabled()) {
            log.debug("queue() - sender={}, message id={}", (Object)sender, (Object)result.getId());
            log.debug(this.toString(message));
        }
        this.schedule();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message send(Message message, MLLPSender sender, MessageQueue queue) throws HL7Exception, LLPException, IOException {
        Message response;
        boolean debug = log.isDebugEnabled();
        long start = -1L;
        if (debug) {
            log.debug("sending message via " + sender);
            log.debug(this.toString(message));
            start = System.currentTimeMillis();
        }
        try (Connection connection = null;){
            connection = this.messageContext.newClient(sender.getHost(), sender.getPort(), false);
            int timeout = sender.getResponseTimeout();
            if (timeout <= 0) {
                timeout = 30;
            }
            connection.getInitiator().setTimeout((long)timeout, TimeUnit.SECONDS);
            response = connection.getInitiator().sendAndReceive(message);
            if (debug) {
                long end = System.currentTimeMillis();
                log.debug("response received in " + (end - start) + "ms");
                log.debug(this.toString(response));
            }
        }
        return response;
    }

    protected void process(Message object, MessageQueue queue) throws Exception {
        MLLPSender connector = queue.getConnector();
        Message response = this.send(object, connector, queue);
        queue.sent(response);
    }

    protected String toString(Message object) {
        try {
            return HL7MessageHelper.toString(object);
        }
        catch (HL7Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return "Failed to encode message";
        }
    }

    private void populate(Message message, MLLPSender sender, HL7Mapping config) throws HL7Exception, IOException {
        this.populator.populate(message, sender, this.createMessageTimestamp(), this.createMessageControlID(), config);
    }

    private MessageQueue getMessageQueue(MLLPSender sender) {
        return this.getQueues().getQueue(sender, true);
    }

    private void update(Connector connector) {
        if (connector instanceof MLLPSender) {
            this.restartSender(connector);
        } else if (connector instanceof MLLPReceiver) {
            this.restartReceiver(connector);
        }
    }

    private void restartReceiver(Connector connector) {
        MessageReceiver receiver = this.receiverMap.get(connector.getReference());
        if (receiver != null) {
            ReceivingApplication app = receiver.getReceivingApplication();
            this.stop(receiver.getConnector());
            try {
                this.listen(connector, app, receiver.getUser());
            }
            catch (InterruptedException exception) {
                log.error("Failed to update " + connector, (Throwable)exception);
                Thread.currentThread().interrupt();
            }
        }
    }

    private void restartSender(Connector connector) {
        MLLPSender sender = (MLLPSender)connector;
        MessageQueue queue = this.getQueues().getQueue(sender, false);
        if (queue != null) {
            log.info("Updating " + connector);
            queue.setConnector(sender);
            queue.setWaitUntil(-1L);
            this.schedule();
        } else {
            this.getMessageQueue(sender);
        }
    }

    private void remove(Connector connector) {
        if (connector instanceof MLLPSender) {
            MessageQueue queue = this.getQueues().remove(connector.getReference());
            if (queue != null) {
                log.info("Removed queue for " + connector);
                queue.setSuspended(true);
            }
        } else if (connector instanceof MLLPReceiver) {
            this.stop(connector);
        }
    }
}

