/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.hl7.impl.HL7Mapping;
import org.openvpms.hl7.io.Connector;

class MLLPReceiver
extends Connector {
    private final int port;

    public MLLPReceiver(int port, String sendingApplication, String sendingFacility, String receivingApplication, String receivingFacility, Reference reference, HL7Mapping mapping) {
        super(sendingApplication, sendingFacility, receivingApplication, receivingFacility, reference, mapping);
        this.port = port;
    }

    public static MLLPReceiver create(Entity object, ArchetypeService service) {
        IMObjectBean bean = service.getBean((IMObject)object);
        HL7Mapping mapping = MLLPReceiver.getMapping(bean, service);
        return new MLLPReceiver(bean.getInt("port"), bean.getString("sendingApplication"), bean.getString("sendingFacility"), bean.getString("receivingApplication"), bean.getString("receivingFacility"), object.getObjectReference(), mapping);
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = super.equals(obj) && obj instanceof MLLPReceiver;
        if (result) {
            result = this.port == ((MLLPReceiver)obj).port;
        }
        return result;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("port", this.port).toString();
    }

    @Override
    protected HashCodeBuilder hashCode(HashCodeBuilder builder) {
        return super.hashCode(builder).append(this.port);
    }
}

