/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.v25.message.ORM_O01;
import java.util.List;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.Reference;
import org.openvpms.hl7.impl.ORMProcessor;
import org.openvpms.hl7.impl.ServicesMessageReceiver;
import org.openvpms.hl7.io.Connectors;
import org.openvpms.hl7.io.MessageDispatcher;
import org.openvpms.hl7.laboratory.Laboratories;

public class LaboratoryCancellationServiceImpl
extends ServicesMessageReceiver {
    private final ORMProcessor processor;

    public LaboratoryCancellationServiceImpl(Laboratories laboratories, MessageDispatcher dispatcher, Connectors connectors, IArchetypeService service, PatientRules rules, UserRules userRules) {
        super(laboratories, service, dispatcher, connectors);
        this.processor = new ORMProcessor(service, rules, userRules);
        this.listen();
    }

    @Override
    public boolean canProcess(Message message) {
        return message instanceof ORM_O01;
    }

    @Override
    public void process(Message message, Reference location) throws HL7Exception {
        List<Act> acts = this.process((ORM_O01)message, location);
        this.getService().save(acts);
    }

    protected List<Act> process(ORM_O01 message, Reference location) throws HL7Exception {
        return this.processor.process(message, location);
    }
}

