/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

public class HL7Mapping {
    private boolean sendADT = true;
    private boolean sendUpdatePatient = true;
    private boolean sendCancelAdmit = true;
    private boolean populatePID3 = true;
    private boolean populatePID2;
    private String male = "M";
    private String maleDesexed = "C";
    private String female = "F";
    private String femaleDesexed = "S";
    private String unknownSex = "U";
    private String speciesLookup;
    private String unmappedSpecies;
    private boolean includeMillis = true;
    private boolean includeTimeZone = true;

    public boolean sendADT() {
        return this.sendADT;
    }

    public void setSendADT(boolean sendADT) {
        this.sendADT = sendADT;
    }

    public boolean sendUpdatePatient() {
        return this.sendUpdatePatient;
    }

    public void setSendUpdatePatient(boolean sendUpdatePatient) {
        this.sendUpdatePatient = sendUpdatePatient;
    }

    public boolean sendCancelAdmit() {
        return this.sendCancelAdmit;
    }

    public void setSendCancelAdmit(boolean sendCancelAdmit) {
        this.sendCancelAdmit = sendCancelAdmit;
    }

    public boolean getPopulatePID3() {
        return this.populatePID3;
    }

    public void setPopulatePID3(boolean populatePID3) {
        this.populatePID3 = populatePID3;
    }

    public boolean getPopulatePID2() {
        return this.populatePID2;
    }

    public void setPopulatePID2(boolean populatePID2) {
        this.populatePID2 = populatePID2;
    }

    public String getMale() {
        return this.male;
    }

    public void setMale(String male) {
        this.male = male;
    }

    public String getMaleDesexed() {
        return this.maleDesexed;
    }

    public void setMaleDesexed(String maleDesexed) {
        this.maleDesexed = maleDesexed;
    }

    public String getFemale() {
        return this.female;
    }

    public void setFemale(String female) {
        this.female = female;
    }

    public String getFemaleDesexed() {
        return this.femaleDesexed;
    }

    public void setFemaleDesexed(String femaleDesexed) {
        this.femaleDesexed = femaleDesexed;
    }

    public void setUnknownSex(String unknownSex) {
        this.unknownSex = unknownSex;
    }

    public String getUnknownSex() {
        return this.unknownSex;
    }

    public String getSpeciesLookup() {
        return this.speciesLookup;
    }

    public void setSpeciesLookup(String speciesLookup) {
        this.speciesLookup = speciesLookup;
    }

    public String getUnmappedSpecies() {
        return this.unmappedSpecies;
    }

    public void setUnmappedSpecies(String unmappedSpecies) {
        this.unmappedSpecies = unmappedSpecies;
    }

    public boolean includeMillis() {
        return this.includeMillis;
    }

    public void setIncludeMillis(boolean includeMillis) {
        this.includeMillis = includeMillis;
    }

    public boolean includeTimeZone() {
        return this.includeTimeZone;
    }

    public void setIncludeTimeZone(boolean includeTimeZone) {
        this.includeTimeZone = includeTimeZone;
    }

    public static HL7Mapping create(Entity mapping, ArchetypeService service) {
        IMObjectBean bean = service.getBean((IMObject)mapping);
        HL7Mapping result = new HL7Mapping();
        result.setSendADT(bean.getBoolean("sendADT", true));
        result.setSendUpdatePatient(bean.getBoolean("sendUpdatePatient", true));
        result.setSendCancelAdmit(bean.getBoolean("sendCancelAdmit", true));
        result.setPopulatePID2(bean.getBoolean("setPID2", true));
        result.setPopulatePID3(bean.getBoolean("setPID3", false));
        result.setMale(bean.getString("male"));
        result.setMaleDesexed(bean.getString("maleDesexed"));
        result.setFemale(bean.getString("female"));
        result.setFemaleDesexed(bean.getString("femaleDesexed"));
        result.setUnknownSex(bean.getString("unknownSex"));
        result.setSpeciesLookup(bean.getString("speciesMapping"));
        result.setUnmappedSpecies(bean.getString("unmappedSpecies"));
        result.setIncludeMillis(bean.getBoolean("includeMillis"));
        result.setIncludeTimeZone(bean.getBoolean("includeTimeZone"));
        return result;
    }
}

