/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.AbstractMonitoringIMObjectCache;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.hl7.impl.MLLPReceiver;
import org.openvpms.hl7.impl.MLLPSender;
import org.openvpms.hl7.io.Connector;
import org.openvpms.hl7.io.Connectors;
import org.openvpms.hl7.util.HL7Archetypes;

public class ConnectorsImpl
extends AbstractMonitoringIMObjectCache<Entity>
implements Connectors {
    private final Map<Long, State> connectors = new HashMap<Long, State>();
    private final List<Listener> listeners = new ArrayList<Listener>();

    public ConnectorsImpl(IArchetypeService service) {
        super(service, HL7Archetypes.CONNECTORS, Entity.class);
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Connector> getConnectors() {
        ArrayList<Connector> result = new ArrayList<Connector>();
        Map<Long, State> map = this.connectors;
        synchronized (map) {
            for (State state : this.connectors.values()) {
                result.add(state.connector);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connector getConnector(Reference reference) {
        State state;
        Connector connector = null;
        Map<Long, State> map = this.connectors;
        synchronized (map) {
            state = this.connectors.get(reference.getId());
        }
        if (state != null) {
            connector = state.connector;
        } else {
            Entity object = (Entity)this.get(reference);
            if (object != null) {
                connector = this.update(object);
            }
        }
        return connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        List<Listener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        List<Listener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    protected Entity addObject(Entity object) {
        Connector connector = this.update(object);
        if (connector != null) {
            for (Listener listener : this.getListeners()) {
                listener.added(connector);
            }
        }
        return connector != null ? object : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeObject(Entity object) {
        Listener[] listenerArray = this.connectors;
        synchronized (this.connectors) {
            State state = this.connectors.remove(object.getId());
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (state != null) {
                for (Listener listener : this.getListeners()) {
                    listener.removed(state.connector);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Listener[] getListeners() {
        Listener[] result;
        List<Listener> list = this.listeners;
        synchronized (list) {
            result = this.listeners.toArray(new Listener[0]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connector update(Entity object) {
        Connector result = null;
        if (!object.isActive()) {
            this.removeObject(object);
        } else {
            Map<Long, State> map = this.connectors;
            synchronized (map) {
                State state = this.connectors.get(object.getId());
                if ((state == null || state.version < object.getVersion()) && (result = this.create(object)) != null) {
                    this.connectors.put(object.getId(), new State(result, object.getVersion()));
                }
            }
        }
        return result;
    }

    private Connector create(Entity object) {
        Connector result = null;
        if (TypeHelper.isA((IMObject)object, (String)"entity.HL7SenderMLLP")) {
            result = MLLPSender.create(object, (ArchetypeService)this.getService());
        } else if (TypeHelper.isA((IMObject)object, (String)"entity.HL7ReceiverMLLP")) {
            result = MLLPReceiver.create(object, (ArchetypeService)this.getService());
        }
        return result;
    }

    private static class State {
        private final long version;
        private final Connector connector;

        State(Connector connector, long version) {
            this.connector = connector;
            this.version = version;
        }
    }

    public static interface Listener {
        public void added(Connector var1);

        public void removed(Connector var1);
    }
}

