/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2015 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.hl7.util;

import org.openvpms.archetype.rules.act.ActStatus;
import org.openvpms.archetype.rules.workflow.WorkflowStatus;

/**
 * HL7 message act statuses.
 *
 * @author Tim Anderson
 */
public class HL7MessageStatuses {

    /**
     * Message is pending.
     */
    public static final String PENDING = WorkflowStatus.PENDING;

    /**
     * Message has been accepted by the remote service.
     */
    public static final String ACCEPTED = "ACCEPTED";

    /**
     * Message has been rejected by the remote service.
     */
    public static final String ERROR = "ERROR";

    /**
     * Message has been cancelled by the user.
     */
    public static final String CANCELLED = ActStatus.CANCELLED;
}
