/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.MonitoringIMObjectCache;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.hl7.io.Connector;
import org.openvpms.hl7.io.Connectors;
import org.openvpms.hl7.service.Services;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServicesImpl
extends MonitoringIMObjectCache<Entity>
implements Services {
    private final Connectors connectors;
    private final List<Services.Listener> listeners = new ArrayList<Services.Listener>();
    private static final Logger log = LoggerFactory.getLogger(ServicesImpl.class);

    public ServicesImpl(IArchetypeService service, String shortName, Class<Entity> type, boolean prefetch, Connectors connectors) {
        super(service, shortName, type, prefetch);
        this.connectors = connectors;
    }

    @Override
    public List<Entity> getServices() {
        return this.getObjects();
    }

    @Override
    public Entity getService(Reference reference) {
        return (Entity)this.getObject(reference);
    }

    @Override
    public Entity getService(Entity group, Reference location) {
        IMObjectBean bean = this.getService().getBean((IMObject)group);
        for (Reference ref : bean.getTargetRefs("services")) {
            Entity service = this.getService(ref);
            if (service == null || !this.hasLocation(service, location)) continue;
            return service;
        }
        return null;
    }

    @Override
    public Connector getSender(Entity service) {
        IMObjectBean bean = this.getService().getBean((IMObject)service);
        Reference ref = bean.getTargetRef("sender");
        return ref != null ? this.connectors.getConnector(ref) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Services.Listener listener) {
        List<Services.Listener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Services.Listener listener) {
        List<Services.Listener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    protected void added(Entity object) {
        for (Services.Listener listener : this.getListeners()) {
            try {
                listener.added(object);
            }
            catch (Throwable exception) {
                log.error(exception.getMessage(), exception);
            }
        }
    }

    protected void removed(Entity object) {
        for (Services.Listener listener : this.getListeners()) {
            try {
                listener.removed(object);
            }
            catch (Throwable exception) {
                log.error(exception.getMessage(), exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Services.Listener[] getListeners() {
        Services.Listener[] result;
        List<Services.Listener> list = this.listeners;
        synchronized (list) {
            result = this.listeners.toArray(new Services.Listener[0]);
        }
        return result;
    }

    private boolean hasLocation(Entity service, Reference location) {
        IMObjectBean bean = this.getService().getBean((IMObject)service);
        return Objects.equals(location, bean.getTargetRef("location"));
    }
}

