/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.XCN;
import ca.uhn.hl7v2.model.v25.group.RDS_O13_ORDER;
import ca.uhn.hl7v2.model.v25.message.RDS_O13;
import ca.uhn.hl7v2.model.v25.segment.ORC;
import ca.uhn.hl7v2.model.v25.segment.PID;
import ca.uhn.hl7v2.model.v25.segment.RXD;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.finance.order.CustomerOrder;
import org.openvpms.archetype.rules.finance.order.CustomerPharmacyOrder;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.hl7.impl.HL7MessageHelper;
import org.openvpms.hl7.impl.OrderMessageProcessor;

public class RDSProcessor
extends OrderMessageProcessor {
    public RDSProcessor(IArchetypeService service, PatientRules rules, UserRules userRules) {
        super(service, rules, userRules);
    }

    public List<Act> process(RDS_O13 message, Reference location) throws HL7Exception {
        if (message.getORDERReps() < 1) {
            throw new HL7Exception("RDS O13 message contains no order group");
        }
        PID pid = message.getPATIENT().getPID();
        CustomerOrder state = this.createState(pid, location);
        for (int i = 0; i < message.getORDERReps(); ++i) {
            RDS_O13_ORDER group = message.getORDER(i);
            this.addItem(group, state);
        }
        return state.getActs();
    }

    protected CustomerPharmacyOrder createState(Party patient, Party customer, String note, Reference location, IArchetypeService service) {
        return new CustomerPharmacyOrder(patient, customer, note, location, service);
    }

    private void addItem(RDS_O13_ORDER group, CustomerOrder state) {
        IMObjectBean itemBean;
        IMObjectBean bean;
        BigDecimal quantity = this.getQuantity(group);
        if (quantity.signum() >= 0) {
            bean = state.getOrder();
            itemBean = state.createOrderItem();
        } else {
            bean = state.getReturn();
            itemBean = state.createReturnItem();
            quantity = quantity.abs();
        }
        String fillerOrderNumber = group.getORC().getFillerOrderNumber().getEntityIdentifier().getValue();
        if (fillerOrderNumber != null) {
            itemBean.setValue("reference", (Object)fillerOrderNumber);
        }
        FinancialAct invoiceItem = this.addInvoiceItem(group.getORC(), bean, itemBean, state);
        this.addClinician(group, bean, itemBean, (Act)invoiceItem);
        Product product = this.addProduct(group, bean, itemBean);
        if (product != null) {
            this.checkSellingUnits(group, bean, product);
        }
        itemBean.setValue("quantity", (Object)quantity);
    }

    private BigDecimal getQuantity(RDS_O13_ORDER group) {
        String quantity = group.getRXD().getActualDispenseAmount().getValue();
        return StringUtils.isEmpty((CharSequence)quantity) ? BigDecimal.ZERO : new BigDecimal(quantity);
    }

    private Product addProduct(RDS_O13_ORDER group, IMObjectBean bean, IMObjectBean itemBean) {
        RXD rxd = group.getRXD();
        CE code = rxd.getDispenseGiveCode();
        long id = HL7MessageHelper.getId(code);
        Product result = null;
        if (id != -1L) {
            ArchetypeQuery query = new ArchetypeQuery("product.*");
            query.getArchetypeConstraint().setAlias("p");
            query.add((IConstraint)Constraints.eq((String)"id", (Object)id));
            IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.getService(), (IArchetypeQuery)query);
            Product product = result = iterator.hasNext() ? (Product)iterator.next() : null;
        }
        if (result != null) {
            itemBean.setTarget("product", result);
        } else {
            CustomerOrder.addNote((IMObjectBean)bean, (String)("Unknown Dispense Give Code, Id='" + code.getIdentifier().getValue() + "', name='" + code.getText().getValue() + "'"));
        }
        return result;
    }

    private void addClinician(RDS_O13_ORDER group, IMObjectBean bean, IMObjectBean itemBean, Act invoiceItem) {
        IMObjectBean invoiceBean;
        XCN dispensingProvider = group.getRXD().getDispensingProvider(0);
        Reference clinician = null;
        long id = HL7MessageHelper.getId(dispensingProvider.getIDNumber().getValue());
        if (id != -1L) {
            User user = this.getClinician(id);
            if (user != null) {
                clinician = user.getObjectReference();
            }
        } else if (invoiceItem != null && (clinician = (invoiceBean = this.getService().getBean((IMObject)invoiceItem)).getTargetRef("clinician")) == null) {
            clinician = bean.getTargetRef("clinician");
        }
        if (clinician != null) {
            itemBean.setTarget("clinician", clinician);
            if (bean.getTargetRef("clinician") == null) {
                bean.setTarget("clinician", clinician);
            }
        }
    }

    private FinancialAct addInvoiceItem(ORC orc, IMObjectBean bean, IMObjectBean itemBean, CustomerOrder state) {
        FinancialAct invoiceItem = (FinancialAct)this.getOrder("act.customerAccountInvoiceItem", orc, bean, state);
        if (invoiceItem != null) {
            itemBean.setValue("sourceInvoiceItem", (Object)invoiceItem.getObjectReference());
        }
        return invoiceItem;
    }

    private void checkSellingUnits(RDS_O13_ORDER group, IMObjectBean bean, Product product) {
        RXD rxd = group.getRXD();
        CE dispenseUnits = rxd.getActualDispenseUnits();
        String units = dispenseUnits.getIdentifier().getValue();
        IMObjectBean productBean = this.getService().getBean((IMObject)product);
        String sellingUnits = productBean.getString("sellingUnits");
        if (!(StringUtils.isEmpty((CharSequence)units) || StringUtils.isEmpty((CharSequence)sellingUnits) || units.equals(sellingUnits))) {
            String name = dispenseUnits.getText().getValue();
            if (name == null) {
                name = "";
            }
            CustomerOrder.addNote((IMObjectBean)bean, (String)("Dispense Units (Id='" + units + "', name='" + name + "') do not match selling units (" + sellingUnits + ")"));
        }
    }
}

