/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.v25.datatype.EI;
import ca.uhn.hl7v2.model.v25.message.RDE_O11;
import ca.uhn.hl7v2.model.v25.segment.ORC;
import ca.uhn.hl7v2.model.v25.segment.RXO;
import java.math.BigDecimal;
import java.util.Date;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.hl7.impl.AbstractMessageFactory;
import org.openvpms.hl7.impl.HL7Mapping;
import org.openvpms.hl7.impl.PopulateHelper;
import org.openvpms.hl7.patient.PatientContext;

public class RDEMessageFactory
extends AbstractMessageFactory {
    private static final String DISPENSING_UNITS = "dispensingUnits";
    private static final String SELLING_UNITS = "sellingUnits";

    public RDEMessageFactory(HapiContext messageContext, ArchetypeService service, LookupService lookups) {
        super(messageContext, service, lookups);
    }

    public Message createOrder(PatientContext context, Product product, BigDecimal quantity, long placerOrderNumber, String sendingApplication, Date date, HL7Mapping config) {
        return this.createOrder(context, "NW", product, quantity, placerOrderNumber, sendingApplication, date, config);
    }

    public Message updateOrder(PatientContext context, Product product, BigDecimal quantity, long placerOrderNumber, String sendingApplication, Date date, HL7Mapping config) {
        return this.createOrder(context, "RP", product, quantity, placerOrderNumber, sendingApplication, date, config);
    }

    public Message cancelOrder(PatientContext context, Product product, BigDecimal quantity, long placerOrderNumber, String sendingApplication, HL7Mapping config, Date date) {
        return this.createOrder(context, "CA", product, quantity, placerOrderNumber, sendingApplication, date, config);
    }

    public Message discontinueOrder(PatientContext context, Product product, BigDecimal quantity, long placerOrderNumber, String sendingApplication, HL7Mapping config, Date date) {
        return this.createOrder(context, "DC", product, quantity, placerOrderNumber, sendingApplication, date, config);
    }

    private RDE_O11 createOrder(PatientContext context, String orderControl, Product product, BigDecimal quantity, long placerOrderNumber, String sendingApplication, Date date, HL7Mapping config) {
        RDE_O11 rde;
        try {
            rde = new RDE_O11(this.getModelClassFactory());
            this.init((AbstractMessage)rde, "RDE", "O11");
            this.populate(rde.getPATIENT().getPID(), context, config);
            this.populate(rde.getPATIENT().getPATIENT_VISIT().getPV1(), context, config);
            ORC orc = rde.getORDER().getORC();
            orc.getOrderControl().setValue(orderControl);
            EI orderNumber = orc.getPlacerOrderNumber();
            orderNumber.getEntityIdentifier().setValue(Long.toString(placerOrderNumber));
            if (sendingApplication != null) {
                orderNumber.getNamespaceID().setValue(sendingApplication);
            }
            PopulateHelper.populateDTM(orc.getDateTimeOfTransaction().getTime(), date, config);
            if (context.getClinicianId() != -1L) {
                PopulateHelper.populateClinician(orc.getEnteredBy(0), context);
            }
            RXO rxo = rde.getORDER().getORDER_DETAIL().getRXO();
            PopulateHelper.populateProduct(rxo.getRequestedGiveCode(), product);
            IMObjectBean bean = this.getArchetypeService().getBean((IMObject)product);
            String dispensingCode = this.getOptional(bean, DISPENSING_UNITS);
            if (dispensingCode != null) {
                String dispensingName = this.getLookupService().getName((IMObject)product, DISPENSING_UNITS);
                PopulateHelper.populateCE(rxo.getRequestedGiveUnits(), dispensingCode, dispensingName);
            }
            String sellingCode = bean.getString(SELLING_UNITS);
            String dispensingInstructions = this.getOptional(bean, "dispInstructions");
            if (dispensingInstructions != null) {
                rxo.getProviderSAdministrationInstructions(0).getText().setValue(dispensingInstructions);
            }
            rxo.getRequestedDispenseAmount().setValue(quantity.toString());
            if (sellingCode != null) {
                String sellingName = this.getLookupService().getName((IMObject)product, SELLING_UNITS);
                PopulateHelper.populateCE(rxo.getRequestedDispenseUnits(), sellingCode, sellingName);
            }
            this.populateAllergies((Group)rde.getPATIENT(), context);
        }
        catch (Throwable exception) {
            throw new IllegalStateException(exception);
        }
        return rde;
    }

    private String getOptional(IMObjectBean bean, String node) {
        return bean.hasNode(node) ? bean.getString(node) : null;
    }
}

