/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.v25.segment.PV1;
import java.util.Date;
import org.openvpms.hl7.impl.HL7Mapping;
import org.openvpms.hl7.impl.PopulateHelper;
import org.openvpms.hl7.patient.PatientContext;

class PV1Populator {
    PV1Populator() {
    }

    public void populate(PV1 pv1, PatientContext context, HL7Mapping config) throws HL7Exception {
        pv1.getSetIDPV1().setValue("1");
        pv1.getPatientClass().setValue("U");
        pv1.getAssignedPatientLocation().getFacility().getNamespaceID().setValue(context.getLocationName());
        if (context.getClinicianId() != -1L) {
            PopulateHelper.populateClinician(pv1.getAdmittingDoctor(0), context);
        }
        pv1.getVisitNumber().getIDNumber().setValue(Long.toString(context.getVisitId()));
        PopulateHelper.populateDTM(pv1.getAdmitDateTime().getTime(), context.getVisitStartTime(), config);
        Date endTime = context.getVisitEndTime();
        if (endTime != null) {
            PopulateHelper.populateDTM(pv1.getDischargeDateTime(0).getTime(), endTime, config);
        }
    }
}

